/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.remote.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.decentred.remote.net.AbstractTCPConnection;
import net.openhft.chronicle.decentred.remote.net.TCPClientListener;

public class VanillaTCPClient
extends AbstractTCPConnection {
    private final List<InetSocketAddress> socketAddresses = new ArrayList<InetSocketAddress>();
    private final Thread thread;
    private final TCPClientListener clientListener;
    private int nextChannel = -1;

    public VanillaTCPClient(String name, List<InetSocketAddress> socketAddresses, TCPClientListener clientListener) {
        this.clientListener = clientListener;
        this.socketAddresses.addAll(socketAddresses);
        this.thread = new Thread(this::run, name);
        this.thread.start();
    }

    @Override
    protected void close2() {
        if (this.thread != null) {
            this.thread.interrupt();
            Thread.yield();
        }
    }

    @Override
    protected void waitForReconnect() throws IOException {
        int count = 0;
        while (this.channel == null) {
            Jvm.pause((long)1L);
            if (++count <= 1000) continue;
            throw new IOException("not open yet");
        }
    }

    @Override
    protected void onMessage(Bytes<ByteBuffer> bytes) throws IOException {
        this.clientListener.onMessage(this, bytes);
    }

    void run() {
        Bytes readBytes = Bytes.elasticByteBuffer((int)0x100000);
        try {
            while (this.running) {
                if (this.channel == null || !this.channel.isOpen()) {
                    readBytes.clear();
                    this.openChannel();
                    this.clientListener.onNewConnection(this, this.channel);
                    continue;
                }
                try {
                    this.readChannel((Bytes<ByteBuffer>)readBytes);
                }
                catch (IOException ioe) {
                    Jvm.pause((long)1L);
                    if (this.running) {
                        ioe.printStackTrace();
                    }
                    this.channel.close();
                    this.clientListener.onClosedChannel(this);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            readBytes.release();
        }
    }

    private void openChannel() {
        if (++this.nextChannel >= this.socketAddresses.size()) {
            this.nextChannel = 0;
        }
        InetSocketAddress socketAddress = this.socketAddresses.get(this.nextChannel);
        try {
            this.channel(SocketChannel.open(socketAddress));
            Socket socket = this.channel.socket();
            socket.setReceiveBufferSize(0x100000);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.channel(null);
            Jvm.pause((long)500L);
        }
    }
}

