/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.dto;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.decentred.dto.SelfSignedMessage;
import net.openhft.chronicle.decentred.util.AddressLongConverter;
import net.openhft.chronicle.decentred.util.DecentredUtil;
import net.openhft.chronicle.wire.LongConversion;
import org.jetbrains.annotations.NotNull;

public class VerificationEvent
extends SelfSignedMessage<VerificationEvent> {
    @LongConversion(value=AddressLongConverter.class)
    private long addressVerified;
    private Bytes keyVerified = Bytes.allocateElasticDirect((long)32L);

    public long addressVerified() {
        return this.addressVerified;
    }

    public VerificationEvent addressVerified(long addressVerified) {
        this.addressVerified = addressVerified;
        return this;
    }

    public VerificationEvent keyVerified(BytesStore key) {
        this.keyVerified.clear().write(key);
        this.addressVerified = DecentredUtil.toAddress(key);
        return this;
    }

    public BytesStore keyVerified() {
        return this.keyVerified;
    }

    @NotNull
    public <T> T deepCopy() {
        VerificationEvent v2 = new VerificationEvent();
        v2.protocol(this.protocol());
        v2.messageType(this.messageType());
        v2.address(this.address());
        v2.timestampUS(this.timestampUS());
        v2.publicKey(this.publicKey());
        v2.keyVerified(this.keyVerified());
        v2.addressVerified(this.addressVerified());
        return (T)v2;
    }
}

