/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.decentred.dto;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.decentred.dto.SignedMessage;
import net.openhft.chronicle.decentred.dto.VanillaSignedMessage;
import net.openhft.chronicle.decentred.util.AddressLongConverter;
import net.openhft.chronicle.decentred.util.DtoParser;
import net.openhft.chronicle.decentred.util.DtoRegistry;
import net.openhft.chronicle.wire.AbstractMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.IntConversion;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.UnsignedIntConverter;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class TransactionBlockEvent<T>
extends VanillaSignedMessage<TransactionBlockEvent<T>> {
    private transient DtoParser<T> dtoParser;
    private transient Bytes writeTransactions = Bytes.allocateElasticDirect((long)4096L);
    private transient long messagesStart = 0L;
    private transient Bytes transactions = this.writeTransactions.clear();
    private transient List<SignedMessage> transactionsList;
    @LongConversion(value=AddressLongConverter.class)
    private long chainAddress;
    @IntConversion(value=UnsignedIntConverter.class)
    private short weekNumber;
    @IntConversion(value=UnsignedIntConverter.class)
    private int blockNumber;

    public TransactionBlockEvent dtoParser(DtoParser<T> dtoParser) {
        this.dtoParser = Objects.requireNonNull(dtoParser);
        return this;
    }

    @Override
    public void readMarshallable(BytesIn bytes) throws IORuntimeException {
        super.readMarshallable(bytes);
        this.messagesStart = this.bytes.readPosition();
        this.transactions = this.bytes;
    }

    public void replay(DtoRegistry<T> dtoRegistry, T allMessages) {
        if (this.dtoParser == null) {
            this.dtoParser = dtoRegistry.get();
        }
        this.replay(allMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replay(T allMessages) {
        if (this.transactionsList != null) {
            for (SignedMessage signedMessage : this.transactionsList) {
                this.dtoParser.onMessage(allMessages, signedMessage);
            }
        }
        long p0 = this.transactions.readPosition();
        this.transactions.readPosition(this.messagesStart);
        long limit = this.transactions.readLimit();
        try {
            while (!this.transactions.isEmpty()) {
                long position = this.transactions.readPosition();
                long length = this.transactions.readUnsignedInt(position);
                this.transactions.readLimit(position + length);
                try {
                    this.dtoParser.parseOne(this.transactions, allMessages);
                }
                catch (Exception e) {
                    Jvm.warn().on(this.getClass(), "Error processing transaction event ", (Throwable)e);
                }
                this.transactions.readLimit(limit);
                this.transactions.readSkip(length);
            }
        }
        finally {
            this.transactions.readLimit(limit);
            this.transactions.readPosition(p0);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.transactions = this.writeTransactions.clear();
        this.messagesStart = 0L;
    }

    public TransactionBlockEvent addTransaction(SignedMessage message) {
        if (!message.signed()) {
            throw new IllegalArgumentException(message + " must be already signed");
        }
        message.writeMarshallable((BytesOut)this.writeTransactions);
        return this;
    }

    public boolean isEmpty() {
        return this.transactions.readRemaining() == 0L || this.transactionsList != null && !this.transactionsList.isEmpty();
    }

    @Override
    public void writeMarshallable0(BytesOut bytes) {
        super.writeMarshallable0(bytes);
        bytes.write((BytesStore)this.writeTransactions);
    }

    @Override
    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        this.reset();
        super.readMarshallable(wire);
        if (this.transactionsList == null) {
            this.transactionsList = new ArrayList<SignedMessage>();
        }
        wire.read("transactions").sequence((Object)this, (tbe, in) -> {
            while (in.hasNextSequenceItem()) {
                tbe.transactionsList.add((SignedMessage)in.object(VanillaSignedMessage.class));
            }
        });
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        super.writeMarshallable(wire);
        if (this.dtoParser == null && this.transactionsList != null) {
            wire.write((CharSequence)"transactions").sequence(this.transactionsList);
        } else {
            Class superInterface = this.dtoParser.superInterface();
            wire.write((CharSequence)"transactions").sequence(out -> this.replay(Proxy.newProxyInstance(superInterface.getClassLoader(), new Class[]{superInterface}, (InvocationHandler)new AbstractMethodWriterInvocationHandler(){

                protected void handleInvoke(Method method, Object[] args) {
                    out.object(args[0]);
                }
            })));
        }
    }

    @NotNull
    public <T> T deepCopy() {
        TransactionBlockEvent<T> tbe = new TransactionBlockEvent<T>();
        tbe.dtoParser = this.dtoParser;
        tbe.transactions = this.transactions.readRemaining() == 0L ? Bytes.elasticHeapByteBuffer((int)1) : this.transactions.copy().bytesForRead();
        tbe.transactionsList = this.transactionsList;
        return (T)tbe;
    }

    public long chainAddress() {
        return this.chainAddress;
    }

    public TransactionBlockEvent chainAddress(long chainAddress) {
        this.chainAddress = chainAddress;
        return this;
    }

    public int weekNumber() {
        return this.weekNumber & 0xFFFF;
    }

    public long blockNumber() {
        return (long)this.blockNumber & 0xFFFFFFFFL;
    }

    public TransactionBlockEvent blockNumber(long blockNumber) {
        this.blockNumber = (int)blockNumber;
        return this;
    }
}

