/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.io.Closeable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.threads.VanillaEventHandler;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import org.jetbrains.annotations.NotNull;

public class CancellableTimer {
    @NotNull
    private final EventLoop eventLoop;
    @NotNull
    private final TimeProvider timeProvider;

    public CancellableTimer(@NotNull EventLoop eventLoop) {
        this(eventLoop, SystemTimeProvider.INSTANCE);
    }

    public CancellableTimer(@NotNull EventLoop eventLoop, @NotNull TimeProvider timeProvider) {
        this.eventLoop = eventLoop;
        this.timeProvider = timeProvider;
    }

    public Closeable scheduleAtFixedRate(@NotNull VanillaEventHandler eventHandler, long initialDelay, long period) {
        ScheduledEventHandler handler = new ScheduledEventHandler(this.timeProvider, eventHandler, initialDelay, period, HandlerPriority.TIMER);
        this.eventLoop.addHandler(handler);
        return handler;
    }

    public Closeable scheduleAtFixedRate(@NotNull VanillaEventHandler eventHandler, long initialDelay, long period, HandlerPriority priority) {
        ScheduledEventHandler handler = new ScheduledEventHandler(this.timeProvider, eventHandler, initialDelay, period, priority);
        this.eventLoop.addHandler(handler);
        return handler;
    }

    public Closeable schedule(@NotNull Runnable eventHandler, long delay) {
        ScheduledEventHandler handler = new ScheduledEventHandler(this.timeProvider, () -> {
            eventHandler.run();
            throw new InvalidEventHandlerException("just runs once");
        }, delay, 0L);
        this.eventLoop.addHandler(handler);
        return handler;
    }

    protected static final class ScheduledEventHandler
    implements EventHandler,
    Closeable {
        @NotNull
        private final TimeProvider timeProvider;
        @NotNull
        private final VanillaEventHandler eventHandler;
        private final long initialDelayMs;
        private final long periodMs;
        private volatile boolean closed;
        private boolean isFirstTime = true;
        private long lastTimeRan;
        private final HandlerPriority priority;

        private ScheduledEventHandler(@NotNull TimeProvider timeProvider, @NotNull VanillaEventHandler eventHandler, long initialDelayMs, long periodMs) {
            this(timeProvider, eventHandler, initialDelayMs, periodMs, HandlerPriority.TIMER);
        }

        private ScheduledEventHandler(@NotNull TimeProvider timeProvider, @NotNull VanillaEventHandler eventHandler, long initialDelayMs, long periodMs, HandlerPriority priority) {
            this.timeProvider = timeProvider;
            this.initialDelayMs = initialDelayMs;
            this.periodMs = periodMs;
            this.eventHandler = eventHandler;
            this.priority = priority;
            this.lastTimeRan = timeProvider.currentTimeMillis();
        }

        @Override
        public boolean action() throws InvalidEventHandlerException, InvalidMarshallableException {
            if (this.closed) {
                throw InvalidEventHandlerException.reusable();
            }
            long currentTime = this.timeProvider.currentTimeMillis();
            if (this.lastTimeRan + this.waitTimeMs() > currentTime) {
                return false;
            }
            this.isFirstTime = false;
            this.lastTimeRan = currentTime;
            try {
                return this.eventHandler.action();
            }
            catch (RuntimeException e) {
                Jvm.warn().on(this.getClass(), "Unexpected runtime exception", (Throwable)e);
                return false;
            }
        }

        private long waitTimeMs() {
            if (!this.isFirstTime) {
                return this.periodMs;
            }
            return this.initialDelayMs;
        }

        @Override
        @NotNull
        public HandlerPriority priority() {
            return this.priority;
        }

        @Override
        public void close() {
            this.closed = true;
        }

        public String toString() {
            return "ScheduledEventHandler<" + this.eventHandler + '>';
        }
    }
}

