/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public class AnnotationFinder {
    public static <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
        HashSet<Annotation> visited = new HashSet<Annotation>();
        A annotationRecursively = AnnotationFinder.findAnnotationRecursively(annotatedElement, annotationType, visited);
        if (annotationRecursively == null && annotatedElement instanceof Method) {
            Method method = (Method)annotatedElement;
            return AnnotationFinder.findAnnotationForMethod(annotationType, method.getDeclaringClass(), method.getName(), method.getParameterTypes(), visited);
        }
        return annotationRecursively;
    }

    private static <A extends Annotation> A findAnnotationRecursively(AnnotatedElement annotatedElement, Class<A> annotationType, Set<Annotation> visited) {
        try {
            A annotation = annotatedElement.getDeclaredAnnotation(annotationType);
            if (annotation != null) {
                return annotation;
            }
            annotation = AnnotationFinder.findNestedDirectAnnotation(annotatedElement, annotationType, visited);
            if (annotation != null) {
                return annotation;
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }

    private static <A extends Annotation> A findNestedDirectAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType, Set<Annotation> visited) {
        for (Annotation ann : annotatedElement.getDeclaredAnnotations()) {
            A annotation;
            if (!visited.add(ann) || (annotation = AnnotationFinder.findAnnotationRecursively(ann.annotationType(), annotationType, visited)) == null) continue;
            return annotation;
        }
        return null;
    }

    private static <A extends Annotation> A findAnnotationForMethod(Class<A> annoClass, Class<?> aClass, String name, Class<?>[] parameterTypes, HashSet<Annotation> visited) {
        A annotationInSuperclass;
        try {
            Method m = aClass.getMethod(name, parameterTypes);
            A annotationOnMethod = AnnotationFinder.findAnnotationRecursively(m, annoClass, visited);
            if (annotationOnMethod != null) {
                return annotationOnMethod;
            }
        }
        catch (NoSuchMethodException m) {
            // empty catch block
        }
        Class<?> superclass = aClass.getSuperclass();
        if (superclass != null && superclass != Object.class && (annotationInSuperclass = AnnotationFinder.findAnnotationForMethod(annoClass, superclass, name, parameterTypes, visited)) != null) {
            return annotationInSuperclass;
        }
        for (Class<?> iClass : aClass.getInterfaces()) {
            A annotationInInterface = AnnotationFinder.findAnnotationForMethod(annoClass, iClass, name, parameterTypes, visited);
            if (annotationInInterface == null) continue;
            return annotationInInterface;
        }
        return null;
    }
}

