/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.CleaningThread;
import net.openhft.chronicle.core.util.ThrowingConsumer;

public class CleaningThreadLocal<T>
extends ThreadLocal<T> {
    private static final Set<CleaningThreadLocal<?>> cleaningThreadLocals = Collections.synchronizedSet(new LinkedHashSet());
    private final Supplier<T> supplier;
    private final Function<T, T> getWrapper;
    private final ThrowingConsumer<T, Exception> cleanup;
    private Map<Thread, Object> nonCleaningThreadValues = null;

    CleaningThreadLocal(Supplier<T> supplier, ThrowingConsumer<T, Exception> cleanup) {
        this(supplier, cleanup, UnaryOperator.identity());
    }

    CleaningThreadLocal(Supplier<T> supplier, ThrowingConsumer<T, Exception> cleanup, UnaryOperator<T> getWrapper) {
        this.supplier = supplier;
        this.cleanup = cleanup;
        this.getWrapper = getWrapper;
        assert (this.trackNonCleaningThreads());
    }

    public static <T> CleaningThreadLocal<T> withCloseQuietly(Supplier<T> supplier) {
        return new CleaningThreadLocal<Object>(supplier, Closeable::closeQuietly);
    }

    public static <T> CleaningThreadLocal<T> withCleanup(ThrowingConsumer<T, Exception> cleanup) {
        return new CleaningThreadLocal<Object>(() -> null, cleanup);
    }

    public static <T> CleaningThreadLocal<T> withCleanup(Supplier<T> supplier, ThrowingConsumer<T, Exception> cleanup) {
        return new CleaningThreadLocal<T>(supplier, cleanup);
    }

    public static <T> CleaningThreadLocal<T> withCleanup(Supplier<T> supplier, ThrowingConsumer<T, Exception> cleanup, Function<T, T> getWrapper) {
        return new CleaningThreadLocal<T>(supplier, cleanup, getWrapper::apply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupNonCleaningThreads() {
        if (cleaningThreadLocals.isEmpty()) {
            return;
        }
        Set<CleaningThreadLocal<?>> set = cleaningThreadLocals;
        synchronized (set) {
            Iterator<CleaningThreadLocal<?>> iterator = cleaningThreadLocals.iterator();
            while (iterator.hasNext()) {
                CleaningThreadLocal<?> nctl;
                CleaningThreadLocal<?> nctl2 = nctl = iterator.next();
                Iterator<Map.Entry<Thread, Object>> iter = nctl.nonCleaningThreadValues.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<Thread, Object> entry = iter.next();
                    if (entry.getKey().isAlive()) continue;
                    CleaningThreadLocal nctl2b = (CleaningThreadLocal)Jvm.uncheckedCast(nctl2);
                    nctl2b.cleanup(entry.getValue());
                    iter.remove();
                }
                if (!nctl.nonCleaningThreadValues.isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    private boolean trackNonCleaningThreads() {
        cleaningThreadLocals.add(this);
        this.nonCleaningThreadValues = Collections.synchronizedMap(new LinkedHashMap());
        return true;
    }

    @Override
    protected T initialValue() {
        T t = this.supplier.get();
        if (this.nonCleaningThreadValues != null) {
            Thread thread = Thread.currentThread();
            if (thread instanceof CleaningThread) {
                return t;
            }
            this.nonCleaningThreadValues.put(thread, t);
        }
        return t;
    }

    @Override
    public T get() {
        return this.getWrapper.apply(super.get());
    }

    @Override
    public void set(T value) {
        Thread thread = Thread.currentThread();
        if (thread instanceof CleaningThread) {
            CleaningThread.performCleanup(thread, this);
        } else if (this.nonCleaningThreadValues != null) {
            Object o = this.nonCleaningThreadValues.put(thread, value);
            this.cleanup(o);
        }
        super.set(value);
    }

    @Override
    public void remove() {
        Thread thread = Thread.currentThread();
        if (thread instanceof CleaningThread) {
            CleaningThread.performCleanup(thread, this);
        } else if (this.nonCleaningThreadValues != null) {
            Object o = this.nonCleaningThreadValues.remove(thread);
            this.cleanup(o);
        }
        super.remove();
    }

    public synchronized void cleanup(T value) {
        try {
            ThrowingConsumer<T, Exception> lCleanup = this.cleanup;
            if (lCleanup != null && value != null) {
                lCleanup.accept(value);
            }
        }
        catch (Exception e) {
            Jvm.warn().on(this.getClass(), "Exception cleaning up " + value.getClass(), (Throwable)e);
        }
    }
}

