/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import net.openhft.chronicle.core.internal.Bootstrap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CpuClass {
    static final String CPU_MODEL;
    private static final String PROCESS = "process ";

    private CpuClass() {
    }

    public static String getCpuModel() {
        return CPU_MODEL;
    }

    @NotNull
    static Function<String, String> removingTag() {
        return line -> line.replaceFirst("[^:]*+: ", "");
    }

    static {
        String model;
        block34: {
            model = System.getProperty("os.arch", "unknown");
            Logger logger = LoggerFactory.getLogger(CpuClass.class);
            try {
                Path path = Paths.get("/proc/cpuinfo", new String[0]);
                if (Files.isReadable(path)) {
                    model = Files.lines(path).filter(line -> line.startsWith("model name")).map(CpuClass.removingTag()).findFirst().orElse(model);
                    break block34;
                }
                if (Bootstrap.IS_WIN) {
                    String cmd = "wmic cpu get name";
                    Process process = new ProcessBuilder(cmd.split(" ")).redirectErrorStream(true).start();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                        model = reader.lines().map(String::trim).filter(s -> !"Name".equals(s) && !s.isEmpty()).findFirst().orElse(model);
                    }
                    try {
                        int ret = process.waitFor();
                        if (ret != 0) {
                            logger.warn(PROCESS + cmd + " returned " + ret);
                        }
                    }
                    catch (InterruptedException e) {
                        logger.warn(PROCESS + cmd + " waitFor threw ", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    process.destroy();
                    break block34;
                }
                if (!Bootstrap.IS_MAC) break block34;
                String cmd = "sysctl -a";
                Process process = new ProcessBuilder(cmd.split(" ")).redirectErrorStream(true).start();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    model = reader.lines().map(String::trim).filter(s -> s.startsWith("machdep.cpu.brand_string")).map(CpuClass.removingTag()).findFirst().orElse(model);
                }
                try {
                    int ret = process.waitFor();
                    if (ret != 0) {
                        logger.warn(PROCESS + cmd + " returned " + ret);
                    }
                }
                catch (InterruptedException e) {
                    logger.warn(PROCESS + cmd + " waitFor threw ", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                process.destroy();
            }
            catch (IOException e) {
                logger.debug("Unable to read cpuinfo", (Throwable)e);
            }
        }
        CPU_MODEL = model;
    }
}

