/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackTrace
extends Throwable {
    private static final long serialVersionUID = 1L;
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static final int NANOS_PER_MILLI = 1000000;

    public StackTrace() {
        this("stack trace", false);
    }

    public StackTrace(boolean addTimestamp) {
        this("stack trace", null, addTimestamp);
    }

    public StackTrace(String message) {
        this(message, null);
    }

    public StackTrace(String message, boolean addTimestamp) {
        this(message, null, addTimestamp);
    }

    public StackTrace(String message, Throwable cause) {
        this(message, cause, false);
    }

    public StackTrace(String message, Throwable cause, boolean addTimestamp) {
        super(message + " on " + Thread.currentThread().getName() + (addTimestamp ? " at " + StackTrace.nanosAsZonedDateTime() : ""), cause);
    }

    @Nullable
    public static StackTrace forThread(Thread t) {
        if (t == null) {
            return null;
        }
        StackTraceElement[] stackTrace = t.getStackTrace();
        if (stackTrace.length > 2 && stackTrace[0].isNativeMethod()) {
            stackTrace = Arrays.copyOfRange(stackTrace, 1, stackTrace.length);
        }
        return new Less(t.toString(), stackTrace);
    }

    @NotNull
    private static ZonedDateTime nanosAsZonedDateTime() {
        long nowNanos = System.currentTimeMillis() * 1000000L;
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(nowNanos / NANOS_PER_SECOND, nowNanos % NANOS_PER_SECOND), ZoneOffset.UTC);
    }

    public static class Less
    extends StackTrace {
        private static final long serialVersionUID = 1L;

        public Less(String message) {
            super(message, true);
        }

        public Less(String message, StackTraceElement[] stackTrace) {
            this(message);
            this.setStackTrace(stackTrace);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

