/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import java.awt.Desktop;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.util.URIEncoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Deprecated
public class WebExceptionHandler
implements ExceptionHandler {
    private final Properties properties = new Properties();
    @NotNull
    private final ExceptionHandler fallBack;
    private final String baseURI;

    public WebExceptionHandler(String propertiesFile, @NotNull ExceptionHandler fallBack) {
        assert (fallBack != null);
        this.fallBack = fallBack;
        InputStream stream = WebExceptionHandler.class.getResourceAsStream(propertiesFile);
        try {
            if (stream != null) {
                this.properties.load(stream);
            }
        }
        catch (IOException e) {
            Slf4jExceptionHandler.WARN.on(this.getClass(), "Unable to load " + propertiesFile, (Throwable)e);
        }
        this.baseURI = this.properties.getProperty("baseUri", "http://stackoverflow.com/search?q=%5Bjava%5D");
    }

    @Override
    public void on(@NotNull Logger logger, @Nullable String message, @Nullable Throwable t) {
        while (t != null && t.getCause() != null && t.getCause() != t) {
            t = t.getCause();
        }
        String uri = t == null ? null : this.properties.getProperty(t.getClass().getName());
        if (uri == null) {
            uri = this.baseURI;
            String version = Jvm.getProperty("java.version");
            if (version.compareTo("1.5") >= 0) {
                @NotNull String[] parts = version.split("\\.");
                version = parts[1];
            }
            uri = uri + "+" + version;
            if (t != null) {
                uri = uri + "+" + URIEncoder.encodeURI(t.toString());
            }
            uri = uri + "+" + URIEncoder.encodeURI(logger.getName());
            if (message != null) {
                uri = uri + "+" + URIEncoder.encodeURI(message);
            }
        }
        try {
            if (Jvm.isDebug() && Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(uri));
            } else {
                this.fallBack.on(logger, message, t);
            }
        }
        catch (Exception e) {
            this.fallBack.on(WebExceptionHandler.class, "Failed to open browser", (Throwable)e);
        }
    }
}

