/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;

public class UniqueMicroTimeProvider
implements TimeProvider {
    public static final UniqueMicroTimeProvider INSTANCE = new UniqueMicroTimeProvider();
    private final AtomicLong lastTime = new AtomicLong();
    private TimeProvider provider = SystemTimeProvider.INSTANCE;

    public UniqueMicroTimeProvider provider(TimeProvider provider) throws IllegalStateException {
        this.provider = provider;
        this.lastTime.set(provider.currentTimeMicros());
        return this;
    }

    @Override
    public long currentTimeMillis() {
        long time = this.provider.currentTimeMillis();
        while (true) {
            long time0;
            long timeMS;
            if ((timeMS = (time0 = this.lastTime.get()) / 1000L) >= time) {
                this.assertTimeMS(time, timeMS);
                time = (timeMS + 1L) * 1000L;
            }
            if (this.lastTime.compareAndSet(time0, time)) {
                return time;
            }
            Jvm.nanoPause();
        }
    }

    @Override
    public long currentTimeMicros() throws IllegalStateException {
        long time = this.provider.currentTimeMicros();
        while (true) {
            long lastTimeUS;
            if ((lastTimeUS = this.lastTime.get()) >= time) {
                this.assertTime(time, lastTimeUS);
                time = lastTimeUS + 1L;
            }
            if (this.lastTime.compareAndSet(lastTimeUS, time)) {
                return time;
            }
            Jvm.nanoPause();
        }
    }

    @Override
    public long currentTimeNanos() throws IllegalStateException {
        long time = this.provider.currentTimeNanos();
        long timeUS = time / 1000L;
        while (true) {
            long lastTimeUS;
            if ((lastTimeUS = this.lastTime.get()) >= time / 1000L) {
                this.assertTime(timeUS, lastTimeUS);
                timeUS = lastTimeUS + 1L;
                time = timeUS * 1000L;
            }
            if (this.lastTime.compareAndSet(lastTimeUS, timeUS)) {
                return time;
            }
            Jvm.nanoPause();
        }
    }

    private void assertTimeMS(long realTimeMS, long lastTimeMS) {
        assert (lastTimeMS - realTimeMS < 1000L) : "Exceeding 1,000 calls per second will advance time by more than 1 second.";
    }

    private void assertTime(long realTimeUS, long lastTimeUS) {
        assert (lastTimeUS - realTimeUS < 1000000L) : "Exceeding 1 million calls per second will advance time by more than 1 second.";
    }
}

