/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.util;

import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.internal.util.NopThreadConfinementAsserter;
import net.openhft.chronicle.core.internal.util.VanillaThreadConfinementAsserter;
import net.openhft.chronicle.core.util.ThreadConfinementAsserter;

public final class ThreadConfinementLifecycle {
    private static final boolean ASSERTIONS_ENABLE = ThreadConfinementLifecycle.assertionsEnable();

    private ThreadConfinementLifecycle() {
    }

    public static ThreadConfinementAsserter create() {
        return ThreadConfinementLifecycle.create(ASSERTIONS_ENABLE);
    }

    public static ThreadConfinementAsserter createEnabled() {
        return ThreadConfinementLifecycle.create(true);
    }

    static ThreadConfinementAsserter create(boolean active) {
        return active ? new VanillaThreadConfinementAsserter() : NopThreadConfinementAsserter.INSTANCE;
    }

    static boolean assertionsEnable() {
        AtomicBoolean ae = new AtomicBoolean();
        assert (ThreadConfinementLifecycle.testAssert(ae));
        return ae.get();
    }

    private static boolean testAssert(AtomicBoolean ae) {
        ae.set(true);
        return true;
    }
}

