/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.util.function.DoubleFunction;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.util.Histogram;
import org.jetbrains.annotations.NotNull;

public class RecordingHistogram
extends Histogram {
    private final Top10 top10 = new Top10();
    private long start;
    private int sampleCount;

    public RecordingHistogram() {
        super(26, 8, 976.5625);
    }

    @Override
    public void sampleNanos(long durationNs) {
        super.sampleNanos(durationNs);
        if (this.start == 0L) {
            this.start = this.currentTimeNanos();
        }
        this.top10.add(durationNs);
    }

    protected long currentTimeNanos() {
        return SystemTimeProvider.CLOCK.currentTimeNanos();
    }

    @Override
    @NotNull
    public String toMicrosFormat(@NotNull DoubleFunction<Double> toMicros) {
        String s = super.toMicrosFormat(toMicros);
        return "{ " + s + ", top: " + this.top10.asString(toMicros, 5) + " }";
    }

    @Override
    @NotNull
    public String toLongMicrosFormat(@NotNull DoubleFunction<Double> toMicros) {
        String s = super.toLongMicrosFormat(toMicros);
        return "{ " + s + ", top: " + this.top10.asString(toMicros, 10) + " }";
    }

    @Override
    public void reset() {
        super.reset();
        this.sampleCount = 0;
        this.top10.reset();
    }

    @Override
    protected String was() {
        return " was: ";
    }

    class Top10 {
        final long[] top = new long[20];
        int count;

        Top10() {
        }

        void add(long duration) {
            if (this.count == 0 || duration > this.top[this.count * 2 - 1]) {
                this.add(RecordingHistogram.this.currentTimeNanos(), duration);
            }
        }

        void add(long time, long duration) {
            for (int i = 0; i < 20 && i < this.count * 2; i += 2) {
                long duration2 = this.top[i + 1];
                if (duration2 >= duration) continue;
                long time2 = this.top[i];
                this.top[i] = time;
                this.top[i + 1] = duration;
                time = time2;
                duration = duration2;
            }
            if (this.count < 10) {
                this.top[this.count * 2] = time;
                this.top[this.count * 2 + 1] = duration;
                ++this.count;
            }
        }

        void reset() {
            this.count = 0;
        }

        public String asString(DoubleFunction<Double> toMicros, int max) {
            if (this.count == 0) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            String sep = "";
            int lim = Math.min(Math.min(20, max * 2), this.count * 2);
            for (int i = 0; i < lim; i += 2) {
                double offset = toMicros.apply(this.top[i] - RecordingHistogram.this.start);
                double duration = toMicros.apply(this.top[i + 1]);
                sb.append(sep).append("{ off: ").append(offset).append(", dur: ").append(duration).append(" }");
                sep = ", ";
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

