/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.lang.ref.Reference;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collection;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.QueryCloseable;
import org.jetbrains.annotations.Nullable;

public interface Closeable
extends java.io.Closeable,
QueryCloseable {
    public static void closeQuietly(Object ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Object o : closeables) {
            Closeable.closeQuietly(o);
        }
    }

    public static void closeQuietly(@Nullable Object o) {
        if (o instanceof Collection) {
            Collection coll = (Collection)o;
            if (coll.isEmpty()) {
                return;
            }
            new ArrayList<Object>(coll).forEach(Closeable::closeQuietly);
        } else if (o instanceof Object[]) {
            for (Object o2 : (Object[])o) {
                Closeable.closeQuietly(o2);
            }
        } else if (o instanceof AutoCloseable) {
            try {
                ((AutoCloseable)o).close();
            }
            catch (Throwable e) {
                Jvm.warn().on(Closeable.class, "Error occurred closing resources", e);
            }
        } else if (o instanceof Reference) {
            Closeable.closeQuietly(((Reference)o).get());
        } else if (o instanceof HttpURLConnection) {
            HttpURLConnection connection = (HttpURLConnection)o;
            connection.disconnect();
        }
    }

    @Override
    public void close();
}

