/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import java.util.function.BiConsumer;
import javax.naming.TimeLimitExceededException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IOTools;

public interface LicenceCheck {
    public static final String CHRONICLE_LICENSE = "chronicle.license";

    public static void check(String product, Class<?> caller) {
        BiConsumer<Long, String> logLicenseExpiryDetails = (days, owner) -> {
            String message;
            String ownerId = owner == null ? "" : "for " + owner + " ";
            String expires = "The license " + ownerId + "expires";
            String string = message = days <= 1L ? expires + " in 1 day" : expires + " in " + days + " days";
            if (days > 500L) {
                message = expires + " in about " + days / 365L + " years";
            }
            String logMessage = message + ". At which point, this product will stop working, if you wish to renew this licence please contact sales@chronicle.software";
            if (days < 30L) {
                Jvm.warn().on(LicenceCheck.class, logMessage);
            } else {
                Jvm.startup().on(LicenceCheck.class, logMessage);
            }
        };
        String key = Jvm.getProperty(CHRONICLE_LICENSE);
        if (key == null || !key.contains(product + '.')) {
            String expiryDateFile = product + ".expiry-date";
            try {
                String source = new String(IOTools.readFile(LicenceCheck.class, expiryDateFile));
                Date expriyDate = new SimpleDateFormat("yyyy-MM-dd").parse(source);
                long days2 = (expriyDate.getTime() - System.currentTimeMillis()) / 86400000L;
                if (days2 < 0L) {
                    throw Jvm.rethrow(new TimeLimitExceededException("Failed to read '" + expiryDateFile));
                }
                logLicenseExpiryDetails.accept(days2, null);
            }
            catch (Throwable t) {
                throw Jvm.rethrow(new TimeLimitExceededException("Failed to read expiry date, from '" + expiryDateFile + "'"));
            }
        } else {
            int start = key.indexOf("expires=") + 8;
            int end = key.indexOf(",", start);
            LocalDate date = LocalDate.parse(key.substring(start, end));
            int start2 = key.indexOf("owner=") + 6;
            int end2 = key.indexOf(",", start2);
            String owner2 = key.substring(start2, end2);
            long days3 = date.toEpochDay() - System.currentTimeMillis() / 86400000L;
            if (days3 < 0L) {
                throw Jvm.rethrow(new TimeLimitExceededException());
            }
            logLicenseExpiryDetails.accept(days3, owner2);
        }
    }

    public void licenceCheck();

    public boolean isAvailable();
}

