/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.invariant.longs;

import java.util.Objects;
import net.openhft.chronicle.core.util.LongTriPredicate;

public enum LongTriCondition implements LongTriPredicate
{
    BETWEEN("\u2208 [fromInclusive, toExclusive), where (fromInclusive, toExclusive) = ", (value, otherFirst, otherSecond) -> value >= otherFirst && value < otherSecond),
    BETWEEN_CLOSED("\u2208 [fromInclusive, toInclusive], where (fromInclusive, toInclusive) = ", (value, otherFirst, otherSecond) -> value >= otherFirst && value <= otherSecond),
    BETWEEN_ZERO_AND_ENSURING("\u2208 [0, index - size ], where (index, size) = ", (value, otherFirst, otherSecond) -> value >= 0L && value <= otherFirst - otherSecond);

    private final String operation;
    private final LongTriPredicate predicate;

    private LongTriCondition(String operation, LongTriPredicate predicate) {
        this.operation = Objects.requireNonNull(operation);
        this.predicate = Objects.requireNonNull(predicate);
    }

    @Override
    public boolean test(long value, long otherFirst, long otherSecond) {
        return this.predicate.test(value, otherFirst, otherSecond);
    }

    public String toString() {
        return this.operation;
    }
}

