/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.MonitorReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.TracingReferenceCounted;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;

public final class VanillaReferenceCounted
implements MonitorReferenceCounted {
    private static final long VALUE = UnsafeMemory.unsafeObjectFieldOffset(Jvm.getField(VanillaReferenceCounted.class, "value"));
    private final Runnable onRelease;
    private final Class<?> type;
    @UsedViaReflection
    private volatile int value = 1;
    private volatile boolean released = false;
    private boolean unmonitored;
    private StackTrace releasedHere;

    VanillaReferenceCounted(Runnable onRelease, Class<?> type) {
        this.onRelease = onRelease;
        this.type = type;
    }

    @Override
    public StackTrace createdHere() {
        return null;
    }

    @Override
    public boolean reservedBy(ReferenceOwner owner) throws IllegalStateException {
        if (this.refCount() <= 0) {
            throw new IllegalStateException(this.type.getName() + " no reservations for " + TracingReferenceCounted.asString(owner));
        }
        return true;
    }

    @Override
    public void reserve(ReferenceOwner id) throws ClosedIllegalStateException {
        int v;
        do {
            if ((v = this.value) > 0) continue;
            throw this.newReleasedClosedIllegalStateException();
        } while (!this.valueCompareAndSet(v, v + 1));
    }

    @Override
    public void reserveTransfer(ReferenceOwner from, ReferenceOwner to) throws ClosedIllegalStateException {
        this.throwExceptionIfReleased();
    }

    @Override
    public boolean tryReserve(ReferenceOwner id) {
        int v;
        do {
            if ((v = this.value) > 0) continue;
            return false;
        } while (!this.valueCompareAndSet(v, v + 1));
        return true;
    }

    private boolean valueCompareAndSet(int from, int to) {
        return UnsafeMemory.INSTANCE.compareAndSwapInt(this, VALUE, from, to);
    }

    @Override
    public void release(ReferenceOwner id) throws ClosedIllegalStateException {
        block1: {
            int count;
            int v;
            do {
                if ((v = this.value) > 0) continue;
                throw this.newReleasedClosedIllegalStateException();
            } while (!this.valueCompareAndSet(v, count = v - 1));
            if (count != 0) break block1;
            this.callOnRelease();
        }
    }

    public void callOnRelease() throws ClosedIllegalStateException {
        if (this.released && !Jvm.supportThread()) {
            throw new ClosedIllegalStateException(this.type.getName() + " already released", this.releasedHere);
        }
        this.releasedHere = Jvm.isResourceTracing() ? new StackTrace("Released here") : null;
        this.released = true;
        this.onRelease.run();
    }

    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        block3: {
            do {
                int v;
                if ((v = this.value) <= 0) {
                    if (!Jvm.supportThread()) {
                        throw this.newReleasedClosedIllegalStateException();
                    }
                    break block3;
                }
                if (v <= 1) continue;
                throw new IllegalStateException(this.type.getName() + " not the last released");
            } while (!this.valueCompareAndSet(1, 0));
            this.callOnRelease();
        }
    }

    @Override
    public int refCount() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public void throwExceptionIfNotReleased() throws IllegalStateException {
        if (this.refCount() > 0) {
            throw new IllegalStateException(this.type.getName() + " still reserved, count=" + this.refCount());
        }
    }

    @Override
    public void warnAndReleaseIfNotReleased() throws ClosedIllegalStateException {
        if (this.refCount() > 0) {
            if (!this.unmonitored && !AbstractCloseable.DISABLE_DISCARD_WARNING) {
                Slf4jExceptionHandler.WARN.on(this.type, "Discarded without being released");
            }
            this.callOnRelease();
        }
    }

    @Override
    public void unmonitored(boolean unmonitored) {
        this.unmonitored = unmonitored;
    }

    @Override
    public boolean unmonitored() {
        return this.unmonitored;
    }

    private ClosedIllegalStateException newReleasedClosedIllegalStateException() {
        return new ClosedIllegalStateException(this.type.getName() + " released");
    }
}

