/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.Bootstrap;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.internal.util.DirectBufferUtil;
import net.openhft.chronicle.core.util.MisAlignedAssertionError;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.misc.Unsafe;

public class UnsafeMemory
implements Memory {
    @NotNull
    public static final Unsafe UNSAFE;
    public static final UnsafeMemory INSTANCE;
    public static final UnsafeMemory MEMORY;
    static final long UNSAFE_COPY_THRESHOLD = 0x100000L;
    public static final boolean IS_LITTLE_ENDIAN;
    private static final long ARRAY_BYTE_BASE_OFFSET;
    private static final long ARRAY_CHAR_BASE_OFFSET;
    private static final String CANNOT_CHANGE_AT = "Cannot change at ";
    private static final String WAS = " was ";
    private static final String EXPECTED = " expected ";
    private final AtomicLong nativeMemoryUsed = new AtomicLong();
    private final ObjectToAddress copyMemoryObjectToAddress = Bootstrap.IS_JAVA_9_PLUS || Bootstrap.isArm0() ? (src, srcOffset, dest, length) -> this.copyMemoryLoop(src, srcOffset, null, dest, length) : (src, srcOffset, dest, length) -> this.copyMemory0(src, srcOffset, null, dest, length);

    private static int retryReadVolatileInt(long address, int value) {
        int value2 = UNSAFE.getIntVolatile(null, address);
        while (value2 != value) {
            if (value != 0 && value != Integer.MIN_VALUE) {
                Jvm.warn().on(UnsafeMemory.class, "Int@" + Long.toHexString(address) + " (" + (address & 0x3FL) + ") was " + Integer.toHexString(value) + " is now " + Integer.toHexString(value2));
            }
            value = value2;
            value2 = UNSAFE.getIntVolatile(null, address);
        }
        return value;
    }

    private static long retryReadVolatileLong(long address, long value) {
        long value2 = UNSAFE.getLongVolatile(null, address);
        while (value2 != value) {
            if (value != 0L) {
                Jvm.warn().on(UnsafeMemory.class, "please add padding() when using concurrent writers, Long@" + Long.toHexString(address) + " (" + (address & 0x3FL) + ") was " + Long.toHexString(value) + " is now " + Long.toHexString(value2));
            }
            value = value2;
            value2 = UNSAFE.getLongVolatile(null, address);
        }
        return value;
    }

    public static void putInt(byte[] bytes, int offset, int value) {
        UNSAFE.putInt(bytes, ARRAY_BYTE_BASE_OFFSET + (long)offset, value);
    }

    public static void unsafeStoreFence() {
        UNSAFE.storeFence();
    }

    public static void unsafeLoadFence() {
        UNSAFE.loadFence();
    }

    public static long unsafeGetLong(long address) {
        return UNSAFE.getLong(address);
    }

    public static int unsafeGetInt(long address) {
        return UNSAFE.getInt(address);
    }

    public static byte unsafeGetByte(long address) {
        return UNSAFE.getByte(address);
    }

    public static void unsafePutLong(long address, long value) {
        UNSAFE.putLong(address, value);
    }

    public static void unsafePutInt(long address, int value) {
        UNSAFE.putInt(address, value);
    }

    public static void unsafePutByte(long address, byte value) {
        UNSAFE.putByte(address, value);
    }

    public static void unsafePutLong(byte[] bytes, int offset, long value) {
        UNSAFE.putLong(bytes, ARRAY_BYTE_BASE_OFFSET + (long)offset, value);
    }

    public static void unsafePutInt(byte[] bytes, int offset, int value) {
        UNSAFE.putInt(bytes, ARRAY_BYTE_BASE_OFFSET + (long)offset, value);
    }

    public static void unsafePutByte(byte[] bytes, int offset, byte value) {
        UNSAFE.putByte(bytes, ARRAY_BYTE_BASE_OFFSET + (long)offset, value);
    }

    public static void copyMemory(long from, long to, int length) {
        MEMORY.copyMemory(from, to, length);
    }

    public static void unsafePutBoolean(Object obj, long offset, boolean value) {
        UNSAFE.putBoolean(obj, offset, value);
    }

    public static boolean unsafeGetBoolean(Object obj, long offset) {
        return UNSAFE.getBoolean(obj, offset);
    }

    public static void unsafePutByte(Object obj, long offset, byte value) {
        UNSAFE.putByte(obj, offset, value);
    }

    public static byte unsafeGetByte(Object obj, long offset) {
        return UNSAFE.getByte(obj, offset);
    }

    public static void unsafePutChar(Object obj, long offset, char value) {
        UNSAFE.putChar(obj, offset, value);
    }

    public static char unsafeGetChar(Object obj, long offset) {
        return UNSAFE.getChar(obj, offset);
    }

    public static void unsafePutShort(Object obj, long offset, short value) {
        UNSAFE.putShort(obj, offset, value);
    }

    public static short unsafeGetShort(Object obj, long offset) {
        return UNSAFE.getShort(obj, offset);
    }

    public static void unsafePutInt(Object obj, long offset, int value) {
        UNSAFE.putInt(obj, offset, value);
    }

    public static int unsafeGetInt(Object obj, long offset) {
        return UNSAFE.getInt(obj, offset);
    }

    public static void unsafePutFloat(Object obj, long offset, float value) {
        UNSAFE.putFloat(obj, offset, value);
    }

    public static float unsafeGetFloat(Object obj, long offset) {
        return UNSAFE.getFloat(obj, offset);
    }

    public static void unsafePutLong(Object obj, long offset, long value) {
        UNSAFE.putLong(obj, offset, value);
    }

    public static long unsafeGetLong(Object obj, long offset) {
        return UNSAFE.getLong(obj, offset);
    }

    public static void unsafePutDouble(Object obj, long offset, double value) {
        UNSAFE.putDouble(obj, offset, value);
    }

    public static double unsafeGetDouble(Object obj, long offset) {
        return UNSAFE.getDouble(obj, offset);
    }

    public static void unsafePutObject(Object obj, long offset, Object value) {
        UNSAFE.putObject(obj, offset, value);
    }

    public static <T> T unsafeGetObject(Object obj, long offset) {
        return (T)UNSAFE.getObject(obj, offset);
    }

    public static long unsafeObjectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    @Override
    @NotNull
    public <E> E allocateInstance(Class<? extends E> clazz) throws InstantiationException {
        @NotNull Object e = UNSAFE.allocateInstance(clazz);
        return (E)e;
    }

    @Override
    public long getFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    @Override
    public void putObject(@NotNull Object object, long offset, Object value) {
        UNSAFE.putObject(ObjectUtils.requireNonNull(object), offset, value);
    }

    @Override
    @NotNull
    public <T> T getObject(@NotNull Object object, long offset) {
        return (T)UNSAFE.getObject(ObjectUtils.requireNonNull(object), offset);
    }

    @Override
    public void storeFence() {
        UNSAFE.storeFence();
    }

    @Override
    public void loadFence() {
        UNSAFE.loadFence();
    }

    @Override
    public void setMemory(long address, long size, byte b) {
        UNSAFE.setMemory(address, size, b);
    }

    @Override
    public void setMemory(Object o, long offset, long size, byte b) {
        UNSAFE.setMemory(o, offset, size, b);
    }

    @Override
    public void freeMemory(long address, long size) {
        if (address != 0L) {
            UNSAFE.freeMemory(address);
        }
        this.nativeMemoryUsed.addAndGet(-size);
    }

    @Override
    public long allocate(long capacity) {
        if (capacity <= 0L) {
            throw new AssertionError((Object)("Invalid capacity: " + capacity));
        }
        long address = UNSAFE.allocateMemory(capacity);
        if (address == 0L) {
            throw new OutOfMemoryError("Not enough free native memory, capacity attempted: " + capacity / 1024L + " KiB");
        }
        this.nativeMemoryUsed.addAndGet(capacity);
        return address;
    }

    @Override
    public long nativeMemoryUsed() {
        return this.nativeMemoryUsed.get();
    }

    @Override
    public void writeByte(long address, byte b) {
        UNSAFE.putByte(address, b);
    }

    @Override
    public void writeByte(Object object, long offset, byte b) {
        UNSAFE.putByte(object, offset, b);
    }

    @Override
    public byte readByte(Object object, long offset) {
        return UNSAFE.getByte(object, offset);
    }

    @Override
    public void writeBytes(long address, byte[] b, int offset, int length) throws IllegalArgumentException {
        if (offset + length > b.length) {
            throw new IllegalArgumentException("Invalid offset or length, array's length is " + b.length);
        }
        UNSAFE.copyMemory(b, ARRAY_BYTE_BASE_OFFSET + (long)offset, null, address, length);
    }

    @Override
    public void readBytes(long address, byte[] b, long offset, int length) throws IllegalArgumentException {
        if (offset + (long)length > (long)b.length) {
            throw new IllegalArgumentException("Invalid offset or length, array's length is " + b.length);
        }
        UNSAFE.copyMemory(null, address, b, ARRAY_BYTE_BASE_OFFSET + offset, length);
    }

    @Override
    public byte readByte(long address) {
        return UNSAFE.getByte(address);
    }

    @Override
    public void writeShort(long address, short i16) {
        UNSAFE.putShort(address, i16);
    }

    @Override
    public void writeShort(Object object, long offset, short i16) {
        UNSAFE.putShort(object, offset, i16);
    }

    @Override
    public short readShort(long address) {
        return UNSAFE.getShort(address);
    }

    @Override
    public short readShort(Object object, long offset) {
        return UNSAFE.getShort(object, offset);
    }

    @Override
    public void writeInt(long address, int i32) {
        UNSAFE.putInt(address, i32);
    }

    @Override
    public void writeInt(Object object, long offset, int i32) {
        UNSAFE.putInt(object, offset, i32);
    }

    @Override
    public void writeOrderedInt(long address, int i32) {
        UNSAFE.putOrderedInt(null, address, i32);
    }

    @Override
    public void writeOrderedInt(Object object, long offset, int i32) {
        UNSAFE.putOrderedInt(object, offset, i32);
    }

    @Override
    public int readInt(long address) {
        return UNSAFE.getInt(address);
    }

    @Override
    public int readInt(Object object, long offset) {
        return UNSAFE.getInt(object, offset);
    }

    @Override
    public void writeLong(long address, long i64) {
        UNSAFE.putLong(address, i64);
    }

    @Override
    public void writeLong(Object object, long offset, long i64) {
        UNSAFE.putLong(object, offset, i64);
    }

    @Override
    public long readLong(long address) {
        return UNSAFE.getLong(address);
    }

    @Override
    public long readLong(Object object, long offset) {
        return UNSAFE.getLong(object, offset);
    }

    @Override
    public void writeFloat(long address, float f) {
        UNSAFE.putFloat(address, f);
    }

    @Override
    public void writeFloat(Object object, long offset, float f) {
        UNSAFE.putFloat(object, offset, f);
    }

    @Override
    public float readFloat(long address) {
        return UNSAFE.getFloat(address);
    }

    @Override
    public float readFloat(Object object, long offset) {
        return UNSAFE.getFloat(object, offset);
    }

    @Override
    public void writeDouble(long address, double d) {
        UNSAFE.putDouble(address, d);
    }

    @Override
    public void writeDouble(Object object, long offset, double d) {
        UNSAFE.putDouble(object, offset, d);
    }

    @Override
    public double readDouble(long address) {
        return UNSAFE.getDouble(address);
    }

    @Override
    public double readDouble(Object object, long offset) {
        return UNSAFE.getDouble(object, offset);
    }

    @Override
    public void copyMemory(byte[] src, int srcOffset, long dest, int length) {
        long offset2 = ARRAY_BYTE_BASE_OFFSET + (long)srcOffset;
        this.copyMemory((Object)src, offset2, dest, length);
    }

    @Override
    public void copyMemory(long src, long dest, long length) {
        if (length < 0x100000L) {
            UNSAFE.copyMemory(src, dest, length);
        } else {
            this.copyMemory0(null, src, null, dest, length);
        }
    }

    @Override
    public void copyMemory(byte[] src, int srcOffset, @Nullable Object dest, long destOffset, int length) {
        if (dest instanceof byte[]) {
            this.copyMemory(src, srcOffset, (byte[])dest, Math.toIntExact(destOffset - ARRAY_BYTE_BASE_OFFSET), length);
        } else {
            this.copyMemoryLoop(src, ARRAY_BYTE_BASE_OFFSET + (long)srcOffset, dest, destOffset, length);
        }
    }

    public void copyMemory(byte[] src, int srcOffset, byte[] dest, int destOffset, int length) {
        long offsetB = ARRAY_BYTE_BASE_OFFSET + (long)srcOffset;
        long offset2B = ARRAY_BYTE_BASE_OFFSET + (long)destOffset;
        if ((long)length < 0x100000L) {
            UNSAFE.copyMemory(src, offsetB, dest, offset2B, length);
        } else {
            this.copyMemory0(src, offsetB, dest, offset2B, length);
        }
    }

    @Override
    public void copyMemory(@Nullable Object src, long srcOffset, long dest, int length) {
        this.copyMemoryObjectToAddress.apply(src, srcOffset, dest, length);
    }

    @Override
    public void copyMemory(@Nullable Object src, long srcOffset, @Nullable Object dest, long destOffset, int length) {
        if (src instanceof byte[]) {
            if (dest instanceof byte[]) {
                this.copyMemory((byte[])src, Math.toIntExact(srcOffset - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET), (byte[])dest, Math.toIntExact(destOffset - ARRAY_BYTE_BASE_OFFSET), length);
            } else {
                this.copyMemoryLoop(src, ARRAY_BYTE_BASE_OFFSET + (long)Math.toIntExact(srcOffset - (long)Unsafe.ARRAY_BYTE_BASE_OFFSET), dest, destOffset, length);
            }
        } else if (src == null) {
            if (dest == null) {
                this.copyMemory(srcOffset, destOffset, length);
            } else {
                this.copyMemory(srcOffset, dest, destOffset, length);
            }
        } else if (dest == null) {
            this.copyMemory(src, srcOffset, destOffset, length);
        } else {
            this.copyMemoryLoop(src, srcOffset, dest, destOffset, length);
        }
    }

    private void copyMemoryLoop(Object src, long srcOffset, Object dest, long destOffset, int length) {
        int i;
        if (src == dest && srcOffset < destOffset) {
            this.backwardCopyMemoryLoop(src, srcOffset, dest, destOffset, length);
            return;
        }
        for (i = 0; i < length - 7; i += 8) {
            MEMORY.writeLong(dest, destOffset + (long)i, UNSAFE.getLong(src, srcOffset + (long)i));
        }
        if (i < length - 3) {
            UNSAFE.putInt(dest, destOffset + (long)i, UNSAFE.getInt(src, srcOffset + (long)i));
            i += 4;
        }
        while (i < length) {
            MEMORY.writeByte(dest, destOffset + (long)i, UNSAFE.getByte(src, srcOffset + (long)i));
            ++i;
        }
    }

    private void backwardCopyMemoryLoop(Object src, long srcOffset, Object dest, long destOffset, int length) {
        int i;
        srcOffset += (long)length;
        destOffset += (long)length;
        for (i = 0; i < length - 7; i += 8) {
            MEMORY.writeLong(dest, destOffset - 8L - (long)i, UNSAFE.getLong(src, srcOffset - 8L - (long)i));
        }
        while (i < length) {
            MEMORY.writeByte(dest, destOffset - 1L - (long)i, UNSAFE.getByte(src, srcOffset - 1L - (long)i));
            ++i;
        }
    }

    @Override
    public void copyMemory(long src, @Nullable Object dest, long destOffset, int length) {
        long time;
        long start = length > 131072 ? System.nanoTime() : 0L;
        this.copyMemoryLoop(null, src, dest, destOffset, length);
        if (length > 131072 && (time = System.nanoTime() - start) > 100000L) {
            Jvm.perf().on(this.getClass(), "Took " + (double)(time / 1000L) / 1000.0 + " ms to copy " + length / 1024 + " KB");
        }
    }

    void copyMemory0(@Nullable Object src, long srcOffset, @Nullable Object dest, long destOffset, long length) {
        while (length > 0L) {
            long size = Math.min(length, 0x100000L);
            UNSAFE.copyMemory(src, srcOffset, dest, destOffset, size);
            length -= size;
            srcOffset += size;
            destOffset += size;
        }
    }

    @Override
    public int stopBitLength(int i) {
        if ((i & 0xFFFFFF80) == 0) {
            return 1;
        }
        return this.stopBitLength0(i);
    }

    private int stopBitLength0(int i) {
        if (i < 0) {
            return 1 + this.stopBitLength(~i);
        }
        return (38 - Integer.numberOfLeadingZeros(i)) / 7;
    }

    @Override
    public int stopBitLength(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        return this.stopBitLength0(l);
    }

    private int stopBitLength0(long l) {
        if (l < 0L) {
            return 1 + this.stopBitLength(l ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return (70 - Long.numberOfLeadingZeros(l)) / 7;
    }

    @Override
    public long partialRead(byte[] bytes, int offset, int length) {
        switch (length) {
            case 8: {
                return UNSAFE.getLong(bytes, ARRAY_BYTE_BASE_OFFSET + (long)offset);
            }
            case 4: {
                return (long)UNSAFE.getInt(bytes, ARRAY_BYTE_BASE_OFFSET + (long)offset) & 0xFFFFFFFFL;
            }
            case 2: {
                return UNSAFE.getShort(bytes, ARRAY_BYTE_BASE_OFFSET + (long)offset) & 0xFFFF;
            }
            case 1: {
                return bytes[offset] & 0xFF;
            }
            case 0: {
                return 0L;
            }
        }
        long value = 0L;
        offset += length;
        if ((length & 4) != 0) {
            value = (long)UNSAFE.getInt(bytes, ARRAY_BYTE_BASE_OFFSET + (long)(offset -= 4)) & 0xFFFFFFFFL;
        }
        if ((length & 2) != 0) {
            value <<= 16;
            int s = UNSAFE.getShort(bytes, ARRAY_BYTE_BASE_OFFSET + (long)(offset -= 2)) & 0xFFFF;
            value |= (long)s;
        }
        if ((length & 1) != 0) {
            value <<= 8;
            int b = bytes[--offset] & 0xFF;
            value |= (long)b;
        }
        return value;
    }

    @Override
    public long partialRead(long addr, int length) {
        switch (length) {
            case 8: {
                return UNSAFE.getLong(addr);
            }
            case 4: {
                return (long)UNSAFE.getInt(addr) & 0xFFFFFFFFL;
            }
            case 2: {
                return UNSAFE.getShort(addr) & 0xFFFF;
            }
            case 1: {
                return UNSAFE.getByte(addr) & 0xFF;
            }
            case 0: {
                return 0L;
            }
        }
        long value = 0L;
        addr += (long)length;
        if ((length & 4) != 0) {
            value = (long)UNSAFE.getInt(addr -= 4L) & 0xFFFFFFFFL;
        }
        if ((length & 2) != 0) {
            value <<= 16;
            int s = UNSAFE.getShort(addr -= 2L) & 0xFFFF;
            value |= (long)s;
        }
        if ((length & 1) != 0) {
            value <<= 8;
            int b = UNSAFE.getByte(--addr) & 0xFF;
            value |= (long)b;
        }
        return value;
    }

    @Override
    public void partialWrite(byte[] bytes, int offset, long value, int length) {
        switch (length) {
            case 8: {
                UNSAFE.putLong(bytes, ARRAY_BYTE_BASE_OFFSET + (long)offset, value);
                return;
            }
            case 4: {
                UNSAFE.putInt(bytes, ARRAY_BYTE_BASE_OFFSET + (long)offset, (int)value);
                return;
            }
            case 2: {
                UNSAFE.putShort(bytes, ARRAY_BYTE_BASE_OFFSET + (long)offset, (short)value);
                return;
            }
            case 1: {
                UNSAFE.putByte(bytes, ARRAY_BYTE_BASE_OFFSET + (long)offset, (byte)value);
                return;
            }
            case 0: {
                return;
            }
        }
        if ((length & 1) != 0) {
            UNSAFE.putByte(bytes, ARRAY_BYTE_BASE_OFFSET + (long)offset, (byte)value);
            ++offset;
            value >>>= 8;
        }
        if ((length & 2) != 0) {
            UNSAFE.putShort(bytes, ARRAY_BYTE_BASE_OFFSET + (long)offset, (short)value);
            offset += 2;
            value >>>= 16;
        }
        if ((length & 4) != 0) {
            UNSAFE.putInt(bytes, ARRAY_BYTE_BASE_OFFSET + (long)offset, (int)value);
        }
    }

    @Override
    public void partialWrite(long addr, long value, int length) {
        switch (length) {
            case 8: {
                UNSAFE.putLong(addr, value);
                return;
            }
            case 4: {
                UNSAFE.putInt(addr, (int)value);
                return;
            }
            case 2: {
                UNSAFE.putShort(addr, (short)value);
                return;
            }
            case 1: {
                UNSAFE.putByte(addr, (byte)value);
                return;
            }
            case 0: {
                return;
            }
        }
        if ((length & 1) != 0) {
            UNSAFE.putByte(addr, (byte)value);
            ++addr;
            value >>>= 8;
        }
        if ((length & 2) != 0) {
            UNSAFE.putShort(addr, (short)value);
            addr += 2L;
            value >>>= 16;
        }
        if ((length & 4) != 0) {
            UNSAFE.putInt(addr, (int)value);
        }
    }

    @Override
    public boolean is7Bit(byte[] bytes, int offset, int length) {
        int i;
        long offset2 = (long)offset + ARRAY_BYTE_BASE_OFFSET;
        for (i = 0; i < length - 7; i += 8) {
            if ((UNSAFE.getLong(bytes, offset2 + (long)i) & 0x8080808080808080L) == 0L) continue;
            return false;
        }
        if (i < length - 3) {
            if ((UNSAFE.getInt(bytes, offset2 + (long)i) & 0x80808080) != 0) {
                return false;
            }
            i += 4;
        }
        if (i < length - 1) {
            if ((UNSAFE.getShort(bytes, offset2 + (long)i) & 0x8080) != 0) {
                return false;
            }
            i += 2;
        }
        if (i < length) {
            return UNSAFE.getByte(bytes, offset2 + (long)i) >= 0;
        }
        return true;
    }

    @Override
    public boolean is7Bit(char[] chars, int offset, int length) {
        int i;
        long offset2 = (long)offset * 2L + ARRAY_CHAR_BASE_OFFSET;
        for (i = 0; i < length - 3; i += 4) {
            if ((UNSAFE.getLong(chars, offset2 + (long)i + (long)i) & 0xFF80FF80FF80FF80L) == 0L) continue;
            return false;
        }
        if (i < length - 1) {
            if ((UNSAFE.getInt(chars, offset2 + (long)i + (long)i) & 0xFF80FF80) != 0) {
                return false;
            }
            i += 2;
        }
        if (i < length) {
            return (UNSAFE.getChar(chars, offset2 + (long)i + (long)i) & 0xFF80) == 0;
        }
        return true;
    }

    @Override
    public boolean is7Bit(long address, int length) {
        int i;
        for (i = 0; i < length - 7; i += 8) {
            if ((UNSAFE.getLong(address + (long)i) & 0x8080808080808080L) == 0L) continue;
            return false;
        }
        if (i < length - 3) {
            if ((UNSAFE.getInt(address + (long)i) & 0x80808080) != 0) {
                return false;
            }
            i += 4;
        }
        if (i < length - 1) {
            if ((UNSAFE.getShort(address + (long)i) & 0x8080) != 0) {
                return false;
            }
            i += 2;
        }
        if (i < length) {
            return UNSAFE.getByte(address + (long)i) >= 0;
        }
        return true;
    }

    @Override
    public void writeOrderedLong(long address, long i) {
        UNSAFE.putOrderedLong(null, address, i);
    }

    @Override
    public void writeOrderedLong(Object object, long offset, long i) {
        UNSAFE.putOrderedLong(object, offset, i);
    }

    @Override
    public void testAndSetInt(long address, long offset, int expected, int value) throws IllegalStateException {
        assert ((address & 0x3FL) <= 60L);
        if (UNSAFE.compareAndSwapInt(null, address, expected, value)) {
            return;
        }
        int actual = UNSAFE.getIntVolatile(null, address);
        throw new IllegalStateException(CANNOT_CHANGE_AT + offset + EXPECTED + expected + WAS + actual);
    }

    @Override
    public void testAndSetInt(Object object, long offset, int expected, int value) throws IllegalStateException {
        if (UNSAFE.compareAndSwapInt(object, offset, expected, value)) {
            return;
        }
        int actual = UNSAFE.getIntVolatile(object, offset);
        throw new IllegalStateException("Cannot change " + object.getClass().getSimpleName() + " at " + offset + EXPECTED + expected + WAS + actual);
    }

    @Override
    public boolean compareAndSwapInt(long address, int expected, int value) throws MisAlignedAssertionError {
        assert ((address & 0x3FL) <= 60L);
        return UNSAFE.compareAndSwapInt(null, address, expected, value);
    }

    @Override
    public boolean compareAndSwapInt(Object object, long offset, int expected, int value) throws MisAlignedAssertionError {
        assert ((offset & 0x3FL) <= 60L);
        return UNSAFE.compareAndSwapInt(object, offset, expected, value);
    }

    @Override
    public boolean compareAndSwapLong(long address, long expected, long value) throws MisAlignedAssertionError {
        if (!this.safeAlignedLong(address)) {
            throw new MisAlignedAssertionError();
        }
        return UNSAFE.compareAndSwapLong(null, address, expected, value);
    }

    @Override
    public boolean compareAndSwapLong(Object object, long offset, long expected, long value) throws MisAlignedAssertionError {
        return UNSAFE.compareAndSwapLong(object, offset, expected, value);
    }

    @Override
    public int pageSize() {
        return UNSAFE.pageSize();
    }

    @Override
    public byte readVolatileByte(long address) {
        return UNSAFE.getByteVolatile(null, address);
    }

    @Override
    public byte readVolatileByte(Object object, long offset) {
        return UNSAFE.getByteVolatile(object, offset);
    }

    @Override
    public short readVolatileShort(long address) {
        return UNSAFE.getShortVolatile(null, address);
    }

    @Override
    public short readVolatileShort(Object object, long offset) {
        return UNSAFE.getShortVolatile(object, offset);
    }

    @Override
    public int readVolatileInt(long address) {
        int value = UNSAFE.getIntVolatile(null, address);
        if ((address & 0x3FL) <= 60L) {
            if (value == 0) {
                value = UNSAFE.getIntVolatile(null, address);
            }
            return value;
        }
        return UnsafeMemory.retryReadVolatileInt(address, value);
    }

    @Override
    public int readVolatileInt(Object object, long offset) {
        return UNSAFE.getIntVolatile(object, offset);
    }

    @Override
    public float readVolatileFloat(long address) {
        return UNSAFE.getFloatVolatile(null, address);
    }

    @Override
    public float readVolatileFloat(Object object, long offset) {
        return UNSAFE.getFloatVolatile(object, offset);
    }

    @Override
    public long readVolatileLong(long address) {
        long value = UNSAFE.getLongVolatile(null, address);
        if ((address & 0x3FL) <= 56L) {
            return value;
        }
        return UnsafeMemory.retryReadVolatileLong(address, value);
    }

    @Override
    public long readVolatileLong(Object object, long offset) {
        return UNSAFE.getLongVolatile(object, offset);
    }

    @Override
    public double readVolatileDouble(long address) {
        return UNSAFE.getDoubleVolatile(null, address);
    }

    @Override
    public double readVolatileDouble(Object object, long offset) {
        return UNSAFE.getDoubleVolatile(object, offset);
    }

    @Override
    public void writeVolatileByte(long address, byte b) {
        UNSAFE.putByteVolatile(null, address, b);
    }

    @Override
    public void writeVolatileByte(Object object, long offset, byte b) {
        UNSAFE.putByteVolatile(object, offset, b);
    }

    @Override
    public void writeVolatileShort(long address, short i16) {
        UNSAFE.putShortVolatile(null, address, i16);
    }

    @Override
    public void writeVolatileShort(Object object, long offset, short i16) {
        UNSAFE.putShortVolatile(object, offset, i16);
    }

    @Override
    public void writeVolatileInt(long address, int i32) {
        UNSAFE.putIntVolatile(null, address, i32);
    }

    @Override
    public void writeVolatileInt(Object object, long offset, int i32) {
        UNSAFE.putIntVolatile(object, offset, i32);
    }

    @Override
    public void writeVolatileFloat(long address, float f) {
        UNSAFE.putFloatVolatile(null, address, f);
    }

    @Override
    public void writeVolatileFloat(Object object, long offset, float f) {
        UNSAFE.putFloatVolatile(object, offset, f);
    }

    @Override
    public void writeVolatileLong(long address, long i64) {
        UNSAFE.putLongVolatile(null, address, i64);
    }

    @Override
    public void writeVolatileLong(Object object, long offset, long i64) {
        UNSAFE.putLongVolatile(object, offset, i64);
    }

    @Override
    public void writeVolatileDouble(long address, double d) {
        UNSAFE.putDoubleVolatile(null, address, d);
    }

    @Override
    public void writeVolatileDouble(Object object, long offset, double d) {
        UNSAFE.putDoubleVolatile(object, offset, d);
    }

    @Override
    public int addInt(long address, int increment) throws MisAlignedAssertionError {
        return UNSAFE.getAndAddInt(null, address, increment) + increment;
    }

    @Override
    public int addInt(Object object, long offset, int increment) {
        return UNSAFE.getAndAddInt(object, offset, increment) + increment;
    }

    @Override
    public long addLong(long address, long increment) throws MisAlignedAssertionError {
        return UNSAFE.getAndAddLong(null, address, increment) + increment;
    }

    @Override
    public long addLong(Object object, long offset, long increment) throws MisAlignedAssertionError {
        return UNSAFE.getAndAddLong(object, offset, increment) + increment;
    }

    public void copy8bit(String s, int start, int length, long addr) {
        if (CachedReflection.STRING_VALUE_OFFSET == 0L) {
            this.copy8BitJava9(s, start, length, addr);
            return;
        }
        char[] chars = (char[])UNSAFE.getObject(s, CachedReflection.STRING_VALUE_OFFSET);
        for (int i = 0; i < length; ++i) {
            UNSAFE.putByte(addr + (long)i, (byte)chars[start + i]);
        }
    }

    private void copy8BitJava9(String s, int start, int length, long addr) {
        for (int i = 0; i < length; ++i) {
            UNSAFE.putByte(addr + (long)i, (byte)s.charAt(start + i));
        }
    }

    public void write8bit(String s, int start, Object object, long offset, int length) {
        if (CachedReflection.STRING_VALUE_OFFSET == 0L) {
            this.write8bitJava9(s, start, object, offset, length);
            return;
        }
        char[] chars = (char[])UNSAFE.getObject(s, CachedReflection.STRING_VALUE_OFFSET);
        for (int i = 0; i < length; ++i) {
            UNSAFE.putByte(object, offset + (long)i, (byte)chars[start + i]);
        }
    }

    private void write8bitJava9(String s, int start, Object object, long offset, int length) {
        for (int i = 0; i < length; ++i) {
            UNSAFE.putByte(object, offset + (long)i, (byte)s.charAt(start + i));
        }
    }

    public boolean isEqual(long addr, String s, int length) {
        if (CachedReflection.STRING_VALUE_OFFSET == 0L) {
            return this.isEqualJava9(addr, s, length);
        }
        char[] chars = (char[])UNSAFE.getObject(s, CachedReflection.STRING_VALUE_OFFSET);
        for (int i = 0; i < length; ++i) {
            if (UNSAFE.getByte(addr + (long)i) == chars[i]) continue;
            return false;
        }
        return true;
    }

    private boolean isEqualJava9(long addr, String s, int length) {
        for (int i = 0; i < length; ++i) {
            if (UNSAFE.getByte(addr + (long)i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean safeAlignedInt(long addr) {
        return (addr & 0x3FL) <= 60L;
    }

    @Override
    public boolean safeAlignedLong(long addr) {
        return (addr & 0x3FL) <= 56L;
    }

    @Override
    public int arrayBaseOffset(Class<?> type) {
        return UNSAFE.arrayBaseOffset(type);
    }

    @Override
    public long objectFieldOffset(Field field) {
        return UNSAFE.objectFieldOffset(field);
    }

    @Override
    public long address(ByteBuffer bb) {
        return DirectBufferUtil.addressOrThrow(bb);
    }

    static {
        IS_LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
        ARRAY_BYTE_BASE_OFFSET = Unsafe.ARRAY_BYTE_BASE_OFFSET;
        ARRAY_CHAR_BASE_OFFSET = Unsafe.ARRAY_CHAR_BASE_OFFSET;
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            e.printStackTrace();
            throw new AssertionError((Object)e);
        }
        MEMORY = INSTANCE = Bootstrap.isArm0() ? new ARMMemory() : new UnsafeMemory();
    }

    private static interface ObjectToAddress {
        public void apply(Object var1, long var2, long var4, int var6);
    }

    static class ARMMemory
    extends UnsafeMemory {
        ARMMemory() {
        }

        @Override
        public short readVolatileShort(long address) {
            if ((address & 1L) == 0L) {
                return super.readVolatileShort(address);
            }
            UNSAFE.loadFence();
            return super.readShort(address);
        }

        @Override
        public void writeVolatileShort(long address, short i16) {
            if ((address & 1L) == 0L) {
                super.writeVolatileShort(address, i16);
            } else {
                super.writeShort(address, i16);
                UNSAFE.storeFence();
            }
        }

        @Override
        public short readVolatileShort(Object object, long offset) {
            if ((offset & 1L) == 0L) {
                return super.readVolatileShort(object, offset);
            }
            UNSAFE.loadFence();
            return super.readShort(object, offset);
        }

        @Override
        public void writeVolatileShort(Object object, long offset, short i16) {
            if ((offset & 1L) == 0L) {
                super.writeVolatileShort(object, offset, i16);
            } else {
                super.writeShort(object, offset, i16);
                UNSAFE.storeFence();
            }
        }

        @Override
        public void writeFloat(long address, float f) {
            if (this.safeAlignedInt(address)) {
                super.writeFloat(address, f);
            } else {
                super.writeInt(address, Float.floatToRawIntBits(f));
            }
        }

        @Override
        public float readFloat(long address) {
            if (this.safeAlignedInt(address)) {
                return super.readFloat(address);
            }
            return Float.intBitsToFloat(super.readInt(address));
        }

        @Override
        public void writeFloat(Object object, long offset, float f) {
            if ((offset & 3L) == 0L) {
                super.writeFloat(object, offset, f);
            } else {
                super.writeInt(object, offset, Float.floatToRawIntBits(f));
            }
        }

        @Override
        public float readFloat(Object object, long offset) {
            if (this.safeAlignedInt(offset)) {
                return super.readFloat(object, offset);
            }
            return Float.intBitsToFloat(super.readInt(object, offset));
        }

        @Override
        public int readVolatileInt(long address) {
            if (this.safeAlignedInt(address)) {
                return super.readVolatileInt(address);
            }
            UNSAFE.loadFence();
            return super.readInt(address);
        }

        @Override
        public int readVolatileInt(Object object, long offset) {
            if (this.safeAlignedInt(offset)) {
                return super.readVolatileInt(object, offset);
            }
            UNSAFE.loadFence();
            return super.readInt(object, offset);
        }

        @Override
        public float readVolatileFloat(long address) {
            if (this.safeAlignedInt(address)) {
                return super.readVolatileFloat(address);
            }
            UNSAFE.loadFence();
            return this.readFloat(address);
        }

        @Override
        public void writeVolatileInt(long address, int i32) {
            if (this.safeAlignedInt(address)) {
                super.writeVolatileInt(address, i32);
            } else {
                this.writeInt(address, i32);
                UNSAFE.storeFence();
            }
        }

        @Override
        public void writeOrderedInt(long address, int i32) {
            if (this.safeAlignedInt(address)) {
                super.writeOrderedInt(address, i32);
            } else {
                this.writeInt(address, i32);
                UNSAFE.storeFence();
            }
        }

        @Override
        public void writeVolatileInt(Object object, long offset, int i32) {
            if ((offset & 3L) == 0L) {
                super.writeVolatileInt(object, offset, i32);
            } else {
                this.writeInt(object, offset, i32);
                UNSAFE.storeFence();
            }
        }

        @Override
        public void writeOrderedInt(Object object, long offset, int i32) {
            if (this.safeAlignedInt(offset)) {
                super.writeOrderedInt(object, offset, i32);
            } else {
                this.writeInt(object, offset, i32);
                UNSAFE.storeFence();
            }
        }

        @Override
        public void writeVolatileFloat(long address, float f) {
            if (this.safeAlignedInt(address)) {
                super.writeVolatileFloat(address, f);
            } else {
                this.writeVolatileInt(address, Float.floatToRawIntBits(f));
            }
        }

        @Override
        public int addInt(long address, int increment) throws MisAlignedAssertionError {
            if (this.safeAlignedInt(address)) {
                return super.addInt(address, increment);
            }
            throw new MisAlignedAssertionError();
        }

        @Override
        public boolean compareAndSwapInt(long address, int expected, int value) throws MisAlignedAssertionError {
            if (this.safeAlignedInt(address)) {
                return super.compareAndSwapInt(address, expected, value);
            }
            throw new MisAlignedAssertionError();
        }

        @Override
        public boolean compareAndSwapInt(Object object, long offset, int expected, int value) throws MisAlignedAssertionError {
            if (this.safeAlignedInt(offset)) {
                return super.compareAndSwapInt(object, offset, expected, value);
            }
            throw new MisAlignedAssertionError();
        }

        @Override
        public void testAndSetInt(long address, long offset, int expected, int value) throws IllegalStateException {
            if (this.safeAlignedInt(address)) {
                if (UNSAFE.compareAndSwapInt(null, address, expected, value)) {
                    return;
                }
                int actual = UNSAFE.getIntVolatile(null, address);
                throw new IllegalStateException(UnsafeMemory.CANNOT_CHANGE_AT + offset + UnsafeMemory.EXPECTED + expected + UnsafeMemory.WAS + actual);
            }
            UNSAFE.loadFence();
            int actual = UNSAFE.getInt(address);
            if (actual == expected) {
                UNSAFE.putInt(address, value);
                UNSAFE.storeFence();
                return;
            }
            throw new IllegalStateException(UnsafeMemory.CANNOT_CHANGE_AT + offset + UnsafeMemory.EXPECTED + expected + UnsafeMemory.WAS + actual + " (mis-aligned)");
        }

        @Override
        public void testAndSetInt(Object object, long offset, int expected, int value) throws IllegalStateException {
            if (this.safeAlignedInt(offset)) {
                if (UNSAFE.compareAndSwapInt(object, offset, expected, value)) {
                    return;
                }
                int actual = UNSAFE.getIntVolatile(object, offset);
                throw new IllegalStateException("Cannot change " + object.getClass().getSimpleName() + " at " + offset + UnsafeMemory.EXPECTED + expected + UnsafeMemory.WAS + actual);
            }
            UNSAFE.loadFence();
            int actual = UNSAFE.getInt(object, offset);
            if (actual == expected) {
                UNSAFE.putInt(object, offset, value);
                UNSAFE.storeFence();
                return;
            }
            throw new IllegalStateException("Cannot perform thread safe operation on " + object.getClass().getSimpleName() + " at " + offset + " as mis-aligned");
        }

        @Override
        public void writeDouble(long address, double d) {
            if (this.safeAlignedLong(address)) {
                super.writeDouble(address, d);
            } else {
                super.writeLong(address, Double.doubleToRawLongBits(d));
            }
        }

        @Override
        public double readDouble(long address) {
            if (this.safeAlignedLong(address)) {
                return super.readDouble(address);
            }
            return Double.longBitsToDouble(super.readLong(address));
        }

        @Override
        public void writeDouble(Object object, long offset, double d) {
            if (this.safeAlignedLong(offset)) {
                super.writeDouble(object, offset, d);
            } else {
                super.writeLong(object, offset, Double.doubleToRawLongBits(d));
            }
        }

        @Override
        public double readDouble(Object object, long offset) {
            if (this.safeAlignedLong(offset)) {
                return super.readDouble(object, offset);
            }
            return Double.longBitsToDouble(super.readLong(object, offset));
        }

        @Override
        public void writeOrderedLong(long address, long i) {
            if (this.safeAlignedLong(address)) {
                super.writeOrderedLong(address, i);
            } else {
                this.writeVolatileLong(address, i);
            }
        }

        @Override
        public long readVolatileLong(long address) {
            if (this.safeAlignedLong(address)) {
                return super.readVolatileLong(address);
            }
            UNSAFE.loadFence();
            return this.readLong(address);
        }

        @Override
        public void writeOrderedLong(Object object, long offset, long i) {
            if (this.safeAlignedLong(offset)) {
                super.writeOrderedLong(object, offset, i);
            } else {
                this.writeVolatileLong(object, offset, i);
            }
        }

        @Override
        public long readVolatileLong(Object object, long offset) {
            if (this.safeAlignedLong(offset)) {
                return super.readVolatileLong(object, offset);
            }
            UNSAFE.loadFence();
            return this.readLong(object, offset);
        }

        @Override
        public double readVolatileDouble(long address) {
            if (this.safeAlignedLong(address)) {
                return super.readVolatileDouble(address);
            }
            UNSAFE.loadFence();
            return this.readDouble(address);
        }

        @Override
        public void writeVolatileLong(Object object, long offset, long i64) {
            if (this.safeAlignedLong(offset)) {
                super.writeVolatileLong(object, offset, i64);
            } else {
                this.writeLong(object, offset, i64);
                UNSAFE.storeFence();
            }
        }

        @Override
        public void writeVolatileLong(long address, long i64) {
            if (this.safeAlignedLong(address)) {
                super.writeVolatileLong(address, i64);
            } else {
                this.writeLong(address, i64);
                UNSAFE.storeFence();
            }
        }

        @Override
        public void writeVolatileDouble(long address, double d) {
            if (this.safeAlignedLong(address)) {
                super.writeVolatileDouble(address, d);
            } else {
                this.writeLong(address, Double.doubleToRawLongBits(d));
            }
        }

        @Override
        public long addLong(long address, long increment) throws MisAlignedAssertionError {
            if (this.safeAlignedLong(address)) {
                return super.addLong(address, increment);
            }
            throw new MisAlignedAssertionError();
        }

        @Override
        public boolean compareAndSwapLong(Object object, long offset, long expected, long value) throws MisAlignedAssertionError {
            if (this.safeAlignedLong(offset)) {
                return super.compareAndSwapLong(object, offset, expected, value);
            }
            throw new MisAlignedAssertionError();
        }

        @Override
        public boolean compareAndSwapLong(long address, long expected, long value) throws MisAlignedAssertionError {
            if (this.safeAlignedLong(address)) {
                return super.compareAndSwapLong(address, expected, value);
            }
            throw new MisAlignedAssertionError();
        }

        @Override
        public boolean safeAlignedInt(long addr) {
            return (addr & 3L) == 0L;
        }

        @Override
        public boolean safeAlignedLong(long addr) {
            return (addr & 7L) == 0L;
        }

        @Override
        public long addLong(Object object, long offset, long increment) throws MisAlignedAssertionError {
            if (this.safeAlignedLong(offset)) {
                return super.addLong(object, offset, increment);
            }
            throw new MisAlignedAssertionError();
        }
    }

    static final class CachedReflection {
        private static final long STRING_VALUE_OFFSET;

        private CachedReflection() {
        }

        static {
            long offset = 0L;
            try {
                if (!Jvm.isJava9Plus()) {
                    Field valueField = String.class.getDeclaredField("value");
                    offset = UNSAFE.objectFieldOffset(valueField);
                }
            }
            catch (NoSuchFieldException e) {
                offset = 0L;
            }
            STRING_VALUE_OFFSET = offset;
        }
    }
}

