/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.watcher;

import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.watcher.FileManager;
import net.openhft.chronicle.core.watcher.JMXFileManagerMBean;

public abstract class JMXFileManager
implements FileManager,
JMXFileManagerMBean {
    protected static final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    protected final String basePath;
    protected final String relativePath;
    private final ObjectName objectName;

    public JMXFileManager(String basePath, String relativePath) {
        this.basePath = basePath;
        this.relativePath = relativePath;
        try {
            this.objectName = new ObjectName(this.jmxPath() + ":type=" + this.type() + ",name=" + relativePath);
        }
        catch (MalformedObjectNameException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected String type() {
        return "basic";
    }

    protected String jmxPath() {
        return "chronicle";
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public void start() {
        try {
            mbs.registerMBean(this, this.objectName);
        }
        catch (Exception e) {
            Jvm.warn().on(this.getClass(), "Unable to register " + this, e);
        }
    }

    @Override
    public void stop() {
        try {
            mbs.unregisterMBean(this.objectName);
        }
        catch (InstanceNotFoundException | MBeanRegistrationException e) {
            Jvm.warn().on(this.getClass(), "Unable to unregister " + this, e);
        }
    }
}

