/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.shutdown;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.PriorityQueue;
import net.openhft.chronicle.core.shutdown.Hooklet;

public class PriorityHook {
    private static PriorityHook registeredHook;
    private final PriorityQueue<Hooklet> hooklets = new PriorityQueue();
    private final HashMap<Hooklet, Hooklet> hookletPool = new LinkedHashMap<Hooklet, Hooklet>();

    private PriorityHook() {
    }

    public static boolean add(int priority, Runnable hook) {
        return PriorityHook.addAndGet(Hooklet.of(priority, hook)).equals(hook);
    }

    public static synchronized <H extends Hooklet> H addAndGet(H hooklet) {
        Hooklet registered;
        if (registeredHook == null) {
            registeredHook = new PriorityHook();
            Runtime.getRuntime().addShutdownHook(new Thread(registeredHook::onShutdown));
        }
        if ((registered = PriorityHook.registeredHook.hookletPool.get(hooklet)) == null) {
            PriorityHook.registeredHook.hookletPool.put(hooklet, hooklet);
            PriorityHook.registeredHook.hooklets.add(hooklet);
            return hooklet;
        }
        return (H)registered;
    }

    public static synchronized void clear() {
        registeredHook = null;
    }

    public void onShutdown() {
        for (Hooklet hooklet : this.hooklets) {
            hooklet.onShutdown();
        }
    }

    public static PriorityHook getRegisteredHook() {
        return registeredHook;
    }
}

