/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import net.openhft.chronicle.core.annotation.Negative;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.annotation.NonPositive;
import net.openhft.chronicle.core.annotation.Positive;
import net.openhft.chronicle.core.annotation.Range;

public final class Longs {
    private Longs() {
    }

    public static long requirePositive(@Positive long val) throws IllegalArgumentException {
        if (val < 1L) {
            throw new IllegalArgumentException(val + " is not positive.");
        }
        return val;
    }

    public static long requireNegative(@Negative long val) throws IllegalArgumentException {
        if (val > -1L) {
            throw new IllegalArgumentException(val + " is not negative.");
        }
        return val;
    }

    public static long requireZero(long val) throws IllegalArgumentException {
        if (val != 0L) {
            throw new IllegalArgumentException(val + " is not zero.");
        }
        return val;
    }

    public static long requireNonPositive(@NonPositive long val) throws IllegalArgumentException {
        if (val > 0L) {
            throw new IllegalArgumentException(val + " is positive.");
        }
        return val;
    }

    public static long requireNonNegative(@NonNegative long val) throws IllegalArgumentException {
        if (val < 0L) {
            throw new IllegalArgumentException(val + " is negative.");
        }
        return val;
    }

    public static long requireNonZero(long val) throws IllegalArgumentException {
        if (val == 0L) {
            throw new IllegalArgumentException(val + " is zero.");
        }
        return val;
    }

    public static long requireEquals(long val, long otherVal) throws IllegalArgumentException {
        if (val != otherVal) {
            throw new IllegalArgumentException(val + " is not equal to " + otherVal);
        }
        return val;
    }

    public static long requireNotEquals(long val, long otherVal) throws IllegalArgumentException {
        if (val == otherVal) {
            throw new IllegalArgumentException(val + " is equal to." + otherVal);
        }
        return val;
    }

    public static long requireInRange(@Range long val, long from, long toExclusive) throws IllegalArgumentException {
        if (val < from || val >= toExclusive) {
            throw new IllegalArgumentException(val + " is not in the range [" + from + ", " + toExclusive + ")");
        }
        return val;
    }

    public static long requireInRangeClosed(@Range long val, long from, long toInclusive) throws IllegalArgumentException {
        if (val < from || val > toInclusive) {
            throw new IllegalArgumentException(val + " is not in the range [" + from + ", " + toInclusive + "]");
        }
        return val;
    }
}

