/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.MonitorReferenceCounted;
import net.openhft.chronicle.core.io.QueryCloseable;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import org.jetbrains.annotations.NotNull;

public final class TracingReferenceCounted
implements MonitorReferenceCounted {
    private final Map<ReferenceOwner, StackTrace> references = Collections.synchronizedMap(new IdentityHashMap());
    private final Map<ReferenceOwner, StackTrace> releases = Collections.synchronizedMap(new IdentityHashMap());
    private final Runnable onRelease;
    private final String uniqueId;
    private final Class type;
    private final StackTrace createdHere;
    private volatile StackTrace releasedHere;

    TracingReferenceCounted(Runnable onRelease, String uniqueId, Class type) {
        this.onRelease = onRelease;
        this.uniqueId = uniqueId;
        this.type = type;
        this.createdHere = this.stackTrace("init", INIT);
        this.references.put(INIT, this.createdHere);
    }

    static String asString(Object id) {
        String s;
        if (id == INIT) {
            return "INIT";
        }
        String string = s = id instanceof ReferenceOwner ? ((ReferenceOwner)id).referenceName() : id.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(id));
        if (id instanceof ReferenceCounted) {
            s = s + " refCount=" + ((ReferenceCounted)id).refCount();
        }
        if (id instanceof Closeable) {
            s = s + " closed=" + ((Closeable)id).isClosed();
        }
        return s;
    }

    @Override
    public StackTrace createdHere() {
        return this.createdHere;
    }

    @Override
    public boolean reservedBy(ReferenceOwner owner) throws IllegalStateException {
        if (this.references.containsKey(owner)) {
            return true;
        }
        StackTrace stackTrace = this.releases.get(owner);
        if (stackTrace == null) {
            throw new IllegalStateException(this.type.getName() + " never reserved by " + TracingReferenceCounted.asString(owner));
        }
        throw new IllegalStateException(this.type.getName() + " no longer reserved by " + TracingReferenceCounted.asString(owner), stackTrace);
    }

    @Override
    public void reserve(ReferenceOwner id) throws IllegalStateException {
        this.tryReserve(id, true);
    }

    @Override
    public boolean tryReserve(ReferenceOwner id) throws IllegalStateException, IllegalArgumentException {
        return this.tryReserve(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryReserve(ReferenceOwner id, boolean must) throws IllegalStateException {
        if (id == this) {
            throw new AssertionError((Object)(this.type.getName() + " the counter cannot reserve itself"));
        }
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            if (this.references.isEmpty()) {
                if (must) {
                    throw new ClosedIllegalStateException(this.type.getName() + " cannot reserve freed resource", this.createdHere);
                }
                return false;
            }
            StackTrace stackTrace = this.references.get(id);
            if (stackTrace != null) {
                throw new IllegalStateException(this.type.getName() + " already reserved resource by " + TracingReferenceCounted.asString(id) + " here", stackTrace);
            }
            this.references.putIfAbsent(id, this.stackTrace("reserve", id));
        }
        this.releases.remove(id);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(ReferenceOwner id) throws IllegalStateException {
        boolean doOnRelease = false;
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            if (this.references.remove(id) == null) {
                StackTrace stackTrace = this.releases.get(id);
                if (stackTrace == null) {
                    Throwable cause = this.createdHere;
                    if (!this.references.isEmpty()) {
                        StackTrace ste = this.references.values().iterator().next();
                        cause = new IllegalStateException(this.type.getName() + " reserved by " + this.referencesAsString(), ste);
                    }
                    throw new IllegalStateException(this.type.getName() + " not reserved by " + TracingReferenceCounted.asString(id), cause);
                }
                throw new ClosedIllegalStateException(this.type.getName() + " already released " + TracingReferenceCounted.asString(id) + " location ", stackTrace);
            }
            this.releases.put(id, this.stackTrace("release", id));
            if (this.references.isEmpty()) {
                doOnRelease = true;
            }
        }
        if (doOnRelease) {
            if (this.releasedHere != null) {
                throw new IllegalStateException(this.type.getName() + " already released", this.releasedHere);
            }
            this.onRelease.run();
            this.releasedHere = new StackTrace(this.type.getName() + " released here");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> referencesAsString() {
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            return this.references.keySet().stream().map(TracingReferenceCounted::asString).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        if (this.references.size() > 1) {
            Exception e0 = null;
            try {
                this.release(id);
            }
            catch (Exception e) {
                e0 = e;
            }
            IllegalStateException ise = new IllegalStateException(this.type.getName() + " still reserved " + this.referencesAsString(), this.createdHere);
            Map<ReferenceOwner, StackTrace> map = this.references;
            synchronized (map) {
                this.references.values().forEach(ise::addSuppressed);
            }
            if (e0 != null) {
                ise.addSuppressed(e0);
            }
            throw ise;
        }
        this.release(id);
    }

    @Override
    public int refCount() {
        return this.references.size();
    }

    @NotNull
    public String toString() {
        return this.uniqueId + " - " + this.referencesAsString();
    }

    @NotNull
    private StackTrace stackTrace(String oper, ReferenceOwner ro) {
        return new StackTrace(this.uniqueId + " " + Thread.currentThread().getName() + " " + oper + " " + TracingReferenceCounted.asString(ro));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void throwExceptionIfNotReleased() throws IllegalStateException {
        Map<ReferenceOwner, StackTrace> map = this.references;
        synchronized (map) {
            if (this.references.isEmpty()) {
                return;
            }
            ClosedIllegalStateException ise = new ClosedIllegalStateException(this.type.getName() + " retained reference closed");
            for (Map.Entry<ReferenceOwner, StackTrace> entry : this.references.entrySet()) {
                ReferenceOwner referenceOwner = entry.getKey();
                StackTrace reservedHere = entry.getValue();
                IllegalStateException ise2 = new IllegalStateException(this.type.getName() + "reserved by " + TracingReferenceCounted.asString(referenceOwner), reservedHere);
                if (referenceOwner instanceof Closeable) {
                    try {
                        ((Closeable)((Object)referenceOwner)).throwExceptionIfClosed();
                    }
                    catch (IllegalStateException ise3) {
                        ise2.addSuppressed(ise3);
                    }
                } else if (referenceOwner instanceof AbstractReferenceCounted) {
                    try {
                        ((AbstractReferenceCounted)referenceOwner).throwExceptionIfReleased();
                    }
                    catch (IllegalStateException ise3) {
                        ise2.addSuppressed(ise3);
                    }
                }
                ise.addSuppressed(ise2);
                if (referenceOwner instanceof AbstractCloseable) {
                    AbstractCloseable ac = (AbstractCloseable)referenceOwner;
                    try {
                        ac.throwExceptionIfClosed();
                    }
                    catch (IllegalStateException e) {
                        ise.addSuppressed(e);
                    }
                    continue;
                }
                if (!(referenceOwner instanceof QueryCloseable)) continue;
                try {
                    ((QueryCloseable)((Object)referenceOwner)).throwExceptionIfClosed();
                }
                catch (Throwable t) {
                    ise.addSuppressed(new ClosedIllegalStateException(this.type.getName() + " closed " + TracingReferenceCounted.asString(referenceOwner), t));
                }
            }
            if (ise.getSuppressed().length > 0) {
                throw ise;
            }
        }
    }

    @Override
    public void throwExceptionIfReleased() throws ClosedIllegalStateException {
        if (this.refCount() <= 0) {
            throw new ClosedIllegalStateException(this.type.getName() + " released", this.releasedHere);
        }
    }

    @Override
    public void warnAndReleaseIfNotReleased() {
        if (this.refCount() > 0) {
            Slf4jExceptionHandler.WARN.on(this.type, "Discarded without being released by " + this.referencesAsString(), this.createdHere);
            this.onRelease.run();
        }
    }
}

