/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.pool.EnumCache;
import net.openhft.chronicle.core.util.CoreDynamicEnum;

public class DynamicEnumClass<E extends CoreDynamicEnum<E>>
extends EnumCache<E> {
    final Map<String, E> eMap = Collections.synchronizedMap(new LinkedHashMap());
    final List<E> eList = new ArrayList();
    E[] values = null;
    private final Field nameField;
    private final Field ordinalField;
    private final Function<String, E> create = this::create;

    DynamicEnumClass(Class<E> eClass) {
        super(eClass);
        CoreDynamicEnum[] enumConstants;
        for (CoreDynamicEnum e : enumConstants = eClass.isEnum() ? (CoreDynamicEnum[])eClass.getEnumConstants() : this.getStaticConstants(eClass)) {
            this.eMap.put(e.name(), e);
            this.eList.add(e);
        }
        this.nameField = Jvm.getField(eClass, "name");
        this.ordinalField = Jvm.getFieldOrNull(eClass, "ordinal");
    }

    private E[] getStaticConstants(Class<E> eClass) {
        Field[] fields;
        ArrayList<CoreDynamicEnum> eList = new ArrayList<CoreDynamicEnum>();
        for (Field field : fields = eClass.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || field.getType() != eClass) continue;
            try {
                field.setAccessible(true);
                Object o = field.get(null);
                eList.add((CoreDynamicEnum)o);
            }
            catch (IllegalAccessException e) {
                Jvm.warn().on(this.getClass(), e.toString());
            }
        }
        return eList.toArray(new CoreDynamicEnum[eList.size()]);
    }

    @Override
    public E get(String name) {
        return (E)((CoreDynamicEnum)this.eMap.get(name));
    }

    @Override
    public E valueOf(String name) {
        return (E)((CoreDynamicEnum)this.eMap.computeIfAbsent(name, this.create));
    }

    private E create(String name) {
        try {
            CoreDynamicEnum e = (CoreDynamicEnum)OS.memory().allocateInstance(this.type);
            this.nameField.set(e, name);
            if (this.ordinalField != null) {
                this.ordinalField.set(e, this.eMap.size());
                this.eList.add(e);
                this.values = null;
            }
            return (E)e;
        }
        catch (Exception e1) {
            throw new AssertionError((Object)e1);
        }
    }

    @Override
    public int size() {
        return this.eMap.size();
    }

    @Override
    public E forIndex(int index) {
        return (E)((CoreDynamicEnum)this.eList.get(index));
    }

    @Override
    public E[] asArray() {
        if (this.values != null) {
            return this.values;
        }
        this.values = this.eList.toArray((CoreDynamicEnum[])Array.newInstance(this.type, this.eList.size()));
        return this.values;
    }

    @Override
    public <T> Map<E, T> createMap() {
        return new TreeMap();
    }

    @Override
    public Set<E> createSet() {
        return new TreeSet();
    }
}

