/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.EnumCache;

public class StaticEnumClass<E extends Enum<E>>
extends EnumCache<E> {
    private final int initialSize;

    StaticEnumClass(Class<E> eClass) {
        super(eClass);
        this.initialSize = StaticEnumClass.guessInitialSize(eClass);
    }

    private static int guessInitialSize(Class<? extends Enum> eClass) {
        Enum[] enumConstants = eClass.getEnumConstants();
        int initialSize = Maths.nextPower2(enumConstants.length * 2, 16);
        for (int i = 0; i < 3; ++i) {
            Enum[] cache = new Enum[initialSize];
            int conflicts = 0;
            for (Enum enumConstant : enumConstants) {
                int n = Maths.hash32(enumConstant.name()) & initialSize - 1;
                if (cache[n] == null) {
                    cache[n] = enumConstant;
                    continue;
                }
                ++conflicts;
            }
            if (conflicts <= 0) continue;
            Jvm.debug().on(eClass, "EnumCache " + initialSize + " conflicts " + conflicts);
            initialSize *= 2;
        }
        return initialSize;
    }

    @Override
    public E valueOf(String name) {
        return name == null || name.isEmpty() ? null : (E)Enum.valueOf(this.eClass, name);
    }

    @Override
    public int initialSize() {
        return this.initialSize;
    }
}

