/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.analytics;

import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.core.Jvm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum StandardMaps {

    private static final long GIB = 0x100000L;

    public static Map<String, String> standardEventParameters(@NotNull String appVersion) {
        return Stream.of(StandardMaps.entry("app_version", appVersion)).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
    }

    public static Map<String, String> standardUserProperties() {
        return Stream.of(StandardMaps.entryFor("java.runtime.name"), StandardMaps.entryFor("java.runtime.version"), StandardMaps.entryFor("os.name"), StandardMaps.entryFor("os.arch"), StandardMaps.entryFor("os.version"), StandardMaps.entry(StandardMaps.replaceDotsWithUnderscore("timezone.default"), TimeZone.getDefault().getID()), StandardMaps.entry(StandardMaps.replaceDotsWithUnderscore("available.processors"), Integer.toString(Runtime.getRuntime().availableProcessors())), StandardMaps.entry(StandardMaps.replaceDotsWithUnderscore("max.memory.gib"), Long.toString(Runtime.getRuntime().maxMemory() / 0x100000L)), StandardMaps.entry(StandardMaps.replaceDotsWithUnderscore("java.major.version"), Long.toString(Jvm.majorVersion())), StandardMaps.entry(StandardMaps.replaceDotsWithUnderscore("max.direct.memory.gib"), Long.toString(Jvm.maxDirectMemory() / 0x100000L))).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
    }

    private static Map.Entry<String, String> entryFor(@NotNull String systemProperty) {
        return new AbstractMap.SimpleImmutableEntry<String, String>(StandardMaps.replaceDotsWithUnderscore(systemProperty), System.getProperty(systemProperty));
    }

    private static Map.Entry<String, String> entry(@NotNull String key, @Nullable String value) {
        return new AbstractMap.SimpleImmutableEntry<String, String>(key, value);
    }

    private static String replaceDotsWithUnderscore(@NotNull String s) {
        return s.replace('.', '_');
    }
}

