/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.StackTrace;
import org.jetbrains.annotations.NotNull;

public class ReferenceCounter {
    private final AtomicLong value = new AtomicLong(1L);
    private final Runnable onRelease;
    private Queue<Throwable> referenceCountHistory;

    private ReferenceCounter(Runnable onRelease) {
        this.onRelease = onRelease;
        assert (this.newRefCountHistory());
    }

    @NotNull
    public static ReferenceCounter onReleased(Runnable onRelease) {
        return new ReferenceCounter(onRelease);
    }

    private boolean newRefCountHistory() {
        this.referenceCountHistory = new ConcurrentLinkedQueue<Throwable>();
        this.referenceCountHistory.add(new StackTrace(Integer.toHexString(this.onRelease.hashCode()) + '-' + Thread.currentThread().getName() + " creation ref-count=" + 1));
        return true;
    }

    public void reserve() throws IllegalStateException {
        long v;
        do {
            if ((v = this.value.get()) > 0L) continue;
            assert (this.recordReservation(v));
            assert (this.logReferenceCountHistory());
            throw new IllegalStateException("Released");
        } while (!this.value.compareAndSet(v, v + 1L));
        assert (this.recordReservation(v + 1L));
    }

    public boolean tryReserve() {
        long v;
        do {
            if ((v = this.value.get()) > 0L) continue;
            return false;
        } while (!this.value.compareAndSet(v, v + 1L));
        assert (this.recordReservation(v + 1L));
        return true;
    }

    private boolean recordReservation(long v) {
        this.referenceCountHistory.add(new StackTrace(Integer.toHexString(this.onRelease.hashCode()) + '-' + Thread.currentThread().getName() + " Reserve ref-count=" + v));
        return true;
    }

    public void release() throws IllegalStateException {
        block4: {
            long v;
            do {
                if ((v = this.value.get()) > 0L) continue;
                assert (this.recordRelease(v));
                assert (this.logReferenceCountHistory());
                throw new IllegalStateException("Released");
            } while (!this.value.compareAndSet(v, v - 1L));
            assert (this.recordRelease(v - 1L));
            if (v != 1L) break block4;
            this.onRelease.run();
        }
    }

    private boolean recordRelease(long v) {
        this.referenceCountHistory.add(new StackTrace(Integer.toHexString(this.onRelease.hashCode()) + '-' + Thread.currentThread().getName() + " Release ref-count=" + v));
        return true;
    }

    private boolean logReferenceCountHistory() {
        System.err.println("Reference count history stack traces (" + this.referenceCountHistory.size() + "):");
        this.referenceCountHistory.forEach(Throwable::printStackTrace);
        return true;
    }

    public long get() {
        return this.value.get();
    }

    @NotNull
    public String toString() {
        return Long.toString(this.value.get());
    }

    public boolean checkRefCount() {
        if (this.value.get() < 1L) {
            throw new IllegalStateException("released", this.referenceCountHistory.peek());
        }
        return true;
    }
}

