/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.Collections;
import java.util.Set;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceCountedTracer;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.onoes.Slf4jExceptionHandler;
import net.openhft.chronicle.core.util.WeakIdentityHashMap;

public abstract class AbstractReferenceCounted
implements ReferenceCountedTracer,
ReferenceOwner {
    static volatile Set<AbstractReferenceCounted> REFERENCE_COUNTED_SET;
    private volatile transient Thread usedByThread;
    private final transient ReferenceCountedTracer referenceCounted;
    private final int referenceId;

    protected AbstractReferenceCounted() {
        this(true);
    }

    protected AbstractReferenceCounted(boolean monitored) {
        Runnable performRelease = BackgroundResourceReleaser.BG_RELEASER && this.performReleaseInBackground() ? this::backgroundPerformRelease : this::inThreadPerformRelease;
        this.referenceId = IOTools.counter(this.getClass()).incrementAndGet();
        this.referenceCounted = ReferenceCountedTracer.onReleased(performRelease, this.referenceName());
        Set<AbstractReferenceCounted> set = REFERENCE_COUNTED_SET;
        if (monitored && set != null) {
            set.add(this);
        }
    }

    public static void enableReferenceTracing() {
        AbstractCloseable.enableCloseableTracing();
        REFERENCE_COUNTED_SET = Collections.newSetFromMap(new WeakIdentityHashMap());
    }

    public static void disableReferenceTracing() {
        AbstractCloseable.disableCloseableTracing();
        REFERENCE_COUNTED_SET = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertReferencesReleased() {
        Set<AbstractReferenceCounted> traceSet = REFERENCE_COUNTED_SET;
        if (traceSet == null) {
            Jvm.warn().on(AbstractReferenceCounted.class, "reference tracing disabled");
            return;
        }
        AbstractCloseable.assertCloseablesClosed();
        AssertionError openFiles = new AssertionError((Object)"Reference counted not released");
        Set<AbstractReferenceCounted> set = traceSet;
        synchronized (set) {
            for (AbstractReferenceCounted key : traceSet) {
                if (key == null || key.refCount() == 0) continue;
                try {
                    key.throwExceptionIfNotReleased();
                }
                catch (Exception e) {
                    ((Throwable)((Object)openFiles)).addSuppressed(e);
                }
            }
        }
        if (((Throwable)((Object)openFiles)).getSuppressed().length > 0) {
            throw openFiles;
        }
    }

    public static void unmonitor(ReferenceCounted counted) {
        if (REFERENCE_COUNTED_SET != null) {
            REFERENCE_COUNTED_SET.remove(counted);
        }
    }

    @Override
    public int referenceId() {
        return this.referenceId;
    }

    @Override
    public StackTrace createdHere() {
        return this.referenceCounted.createdHere();
    }

    @Override
    public void throwExceptionIfNotReleased() {
        this.referenceCounted.throwExceptionIfNotReleased();
    }

    void backgroundPerformRelease() {
        BackgroundResourceReleaser.release(this);
    }

    void inThreadPerformRelease() {
        long start = System.nanoTime();
        this.performRelease();
        long time = System.nanoTime() - start;
        if (time >= 2000000L) {
            Slf4jExceptionHandler.WARN.on(this.getClass(), "Took " + (double)(time / 100000L) / 10.0 + " ms to performRelease");
        }
    }

    protected boolean performReleaseInBackground() {
        return false;
    }

    protected abstract void performRelease();

    @Override
    public void reserve(ReferenceOwner id) throws IllegalStateException {
        this.referenceCounted.reserve(id);
    }

    @Override
    public void release(ReferenceOwner id) throws IllegalStateException {
        this.referenceCounted.release(id);
    }

    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        this.referenceCounted.releaseLast(id);
    }

    @Override
    public boolean tryReserve(ReferenceOwner id) throws IllegalStateException {
        return this.referenceCounted.tryReserve(id);
    }

    @Override
    public void reserveTransfer(ReferenceOwner from, ReferenceOwner to) throws IllegalStateException {
        this.referenceCounted.reserveTransfer(from, to);
    }

    @Override
    public int refCount() {
        return this.referenceCounted.refCount();
    }

    @Override
    public void throwExceptionIfReleased() throws IllegalStateException {
        this.referenceCounted.throwExceptionIfReleased();
    }

    @Override
    public void warnAndReleaseIfNotReleased() {
        this.referenceCounted.warnAndReleaseIfNotReleased();
    }

    @Override
    public boolean reservedBy(ReferenceOwner owner) {
        return this.referenceCounted.reservedBy(owner);
    }

    protected boolean threadSafetyCheck(boolean isUsed) {
        if (!AbstractCloseable.CHECK_THREAD_SAFETY) {
            return true;
        }
        if (this.usedByThread == null && !isUsed) {
            return true;
        }
        Thread currentThread = Thread.currentThread();
        if (this.usedByThread == null || !this.usedByThread.isAlive()) {
            this.usedByThread = currentThread;
        } else if (this.usedByThread != currentThread) {
            throw new IllegalStateException("Component which is not thread safes used by " + this.usedByThread + " and " + currentThread);
        }
        return true;
    }
}

