/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.time.TimeProvider;

public class SetTimeProvider
implements TimeProvider {
    private final AtomicLong nanoTime;
    private long autoIncrement = 0L;

    public SetTimeProvider() {
        this(0L);
    }

    public SetTimeProvider(long initialNanos) {
        this.nanoTime = new AtomicLong(initialNanos);
    }

    public SetTimeProvider(String timestamp) {
        Instant dateTime = LocalDateTime.parse(timestamp).toInstant(ZoneOffset.UTC);
        long initialNanos = dateTime.getEpochSecond() * 1000000000L;
        if (dateTime.isSupported(ChronoField.NANO_OF_SECOND)) {
            initialNanos += dateTime.getLong(ChronoField.NANO_OF_SECOND);
        }
        this.nanoTime = new AtomicLong(initialNanos);
    }

    public SetTimeProvider autoIncrement(long autoIncrement, TimeUnit timeUnit) {
        this.autoIncrement = timeUnit.toNanos(autoIncrement);
        return this;
    }

    public void currentTimeMillis(long millis) {
        this.currentTimeNanos(TimeUnit.MILLISECONDS.toNanos(millis));
    }

    @Override
    public long currentTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.currentTimeNanos());
    }

    public void currentTimeMicros(long micros) {
        this.currentTimeNanos(TimeUnit.MICROSECONDS.toNanos(micros));
    }

    @Override
    public long currentTimeMicros() {
        return TimeUnit.NANOSECONDS.toMicros(this.currentTimeNanos());
    }

    public void currentTimeNanos(long nanos) {
        if (nanos < this.nanoTime.get()) {
            throw new IllegalArgumentException("Cannot go back in time!");
        }
        this.nanoTime.set(nanos);
    }

    @Override
    public long currentTimeNanos() {
        return this.nanoTime.getAndAdd(this.autoIncrement);
    }

    @Override
    public long currentTime(TimeUnit unit) {
        return unit.convert(this.currentTimeNanos(), TimeUnit.NANOSECONDS);
    }

    public SetTimeProvider advanceMillis(long millis) {
        this.advanceNanos(TimeUnit.MILLISECONDS.toNanos(millis));
        return this;
    }

    public SetTimeProvider advanceMicros(long micros) {
        this.advanceNanos(TimeUnit.MICROSECONDS.toNanos(micros));
        return this;
    }

    public SetTimeProvider advanceNanos(long nanos) {
        this.nanoTime.addAndGet(nanos);
        return this;
    }

    public String toString() {
        return "SetTimeProvider{autoIncrement=" + this.autoIncrement + ", nanoTime=" + this.nanoTime + '}';
    }
}

