/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import net.openhft.chronicle.core.io.QueryCloseable;
import net.openhft.chronicle.core.io.QueryCloseables;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceOwner;

public abstract class AbstractReferenceCounted
implements ReferenceCounted,
ReferenceOwner,
QueryCloseable {
    private final ReferenceCounted referenceCounted = ReferenceCounted.onReleased(this::performRelease);
    private final QueryCloseable queryCloseable;

    protected AbstractReferenceCounted() {
        this(QueryCloseables.NEVER_CLOSED);
    }

    protected AbstractReferenceCounted(QueryCloseable queryCloseable) {
        this.queryCloseable = queryCloseable;
    }

    protected abstract void performRelease();

    @Override
    public void reserve(ReferenceOwner id) throws IllegalStateException {
        this.queryCloseable.throwExceptionIfClosed();
        this.referenceCounted.reserve(id);
    }

    @Override
    public void release(ReferenceOwner id) throws IllegalStateException {
        this.referenceCounted.release(id);
    }

    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        this.referenceCounted.releaseLast(id);
    }

    @Override
    public boolean tryReserve(ReferenceOwner id) throws IllegalStateException {
        return !this.queryCloseable.isClosed() && this.referenceCounted.tryReserve(id);
    }

    @Override
    public int refCount() {
        return this.referenceCounted.refCount();
    }

    @Override
    public void throwExceptionBadResourceOwner() throws IllegalStateException {
        this.referenceCounted.throwExceptionBadResourceOwner();
    }

    @Override
    public boolean isClosed() {
        return this.queryCloseable.isClosed();
    }

    @Override
    public void throwExceptionIfClosed() throws IllegalStateException {
        this.queryCloseable.throwExceptionIfClosed();
    }
}

