/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import net.openhft.chronicle.core.time.TimeProvider;

public enum SystemTimeProvider implements TimeProvider
{
    INSTANCE;

    long delta = 0L;

    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public long currentTimeMicros() {
        long nowMS;
        long n0 = System.nanoTime();
        long nowUS = n0 / 1000L;
        long estimate = nowUS + this.delta;
        if (estimate < (nowMS = this.currentTimeMillis() * 1000L)) {
            this.delta = nowMS - nowUS;
            return nowMS;
        }
        if (estimate > nowMS + 1000L) {
            this.delta = (nowMS += 1000L) - nowUS;
            return nowMS;
        }
        return estimate;
    }

    static {
        for (int i = 0; i < 1000; ++i) {
            INSTANCE.currentTimeMicros();
        }
    }
}

