/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.onoes;

import java.io.PrintStream;
import java.time.LocalDateTime;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum PrintExceptionHandler implements ExceptionHandler
{
    WARN{

        @Override
        public void on(@NotNull Class clazz, String message, Throwable thrown) {
            PrintExceptionHandler.printLog(clazz, message, thrown, System.err);
        }
    }
    ,
    DEBUG{

        @Override
        public void on(@NotNull Class clazz, String message, Throwable thrown) {
            PrintExceptionHandler.printLog(clazz, message, thrown, System.out);
        }
    };


    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printLog(@NotNull Class clazz, String message, @Nullable Throwable thrown, PrintStream stream) {
        PrintStream printStream = stream;
        synchronized (printStream) {
            System.err.print(LocalDateTime.now() + " " + Thread.currentThread().getName() + " " + clazz.getSimpleName() + " " + message);
            if (thrown != null) {
                thrown.printStackTrace(System.err);
            } else {
                System.err.println();
            }
        }
    }
}

