/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import net.openhft.chronicle.core.UnsafeMemory;
import sun.misc.VM;

public enum Jvm {

    private static final boolean IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp") || Boolean.getBoolean("debug");
    private static final boolean IS_FLIGHT_RECORDER = (" " + ManagementFactory.getRuntimeMXBean().getInputArguments()).contains(" -XX:+FlightRecorder") || Boolean.getBoolean("jfr");
    private static final Class bitsClass;
    private static final Field reservedMemory;
    private static final AtomicLong reservedMemoryAtomicLong;
    private static final DirectMemoryInspector DIRECT_MEMORY_INSPECTOR;
    private static final boolean IS_64BIT;

    private static boolean is64bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    public static <T extends Throwable> RuntimeException rethrow(Throwable throwable) throws T {
        throw throwable;
    }

    public static void trimStackTrace(StringBuilder sb, StackTraceElement ... stes) {
        int first = Jvm.trimFirst(stes);
        int last = Jvm.trimLast(first, stes);
        for (int i = first; i <= last; ++i) {
            sb.append("\n\tat ").append(stes[i]);
        }
    }

    static int trimFirst(StackTraceElement[] stes) {
        int first;
        for (first = 0; first < stes.length && Jvm.isInternal(stes[first].getClassName()); ++first) {
        }
        return Math.max(0, first - 2);
    }

    public static int trimLast(int first, StackTraceElement[] stes) {
        int last;
        for (last = stes.length - 1; first < last && Jvm.isInternal(stes[last].getClassName()); --last) {
        }
        if (last < stes.length - 1) {
            ++last;
        }
        return last;
    }

    static boolean isInternal(String className) {
        return className.startsWith("jdk.") || className.startsWith("sun.") || className.startsWith("java.");
    }

    public static boolean isDebug() {
        return IS_DEBUG;
    }

    public static boolean isFlightRecorder() {
        return IS_FLIGHT_RECORDER;
    }

    public static void pause(long millis) {
        long timeNanos = millis * 1000000L;
        if ((double)timeNanos > 1.0E9) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            LockSupport.parkNanos(timeNanos);
        }
    }

    public static void busyWaitMicros(long micros) {
        long waitUntil = System.nanoTime() + micros * 1000L;
        while (waitUntil > System.nanoTime()) {
        }
    }

    public static Field getField(Class clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            Class superclass = clazz.getSuperclass();
            if (superclass != null) {
                try {
                    return Jvm.getField(superclass, name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new AssertionError((Object)e);
        }
    }

    public static <V> V getValue(Object obj, String name) {
        for (String n : name.split("/")) {
            Field f = Jvm.getField(obj.getClass(), n);
            try {
                obj = f.get(obj);
                if (obj != null) continue;
                return null;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
        }
        return (V)obj;
    }

    public static String lockWithStack(ReentrantLock lock) {
        Thread t = (Thread)Jvm.getValue(lock, "sync/exclusiveOwnerThread");
        if (t == null) {
            return lock.toString();
        }
        StringBuilder ret = new StringBuilder();
        ret.append(lock).append(" running at");
        Jvm.trimStackTrace(ret, t.getStackTrace());
        return ret.toString();
    }

    public static long usedDirectMemory() {
        return DIRECT_MEMORY_INSPECTOR.usedDirectMemory();
    }

    public static long usedNativeMemory() {
        return UnsafeMemory.INSTANCE.nativeMemoryUsed();
    }

    public static long maxDirectMemory() {
        return VM.maxDirectMemory();
    }

    public static boolean is64bit() {
        return IS_64BIT;
    }

    static {
        IS_64BIT = Jvm.is64bit0();
        try {
            bitsClass = Class.forName("java.nio.Bits");
            reservedMemory = bitsClass.getDeclaredField("reservedMemory");
            reservedMemory.setAccessible(true);
            if (reservedMemory.getType() == AtomicLong.class) {
                reservedMemoryAtomicLong = (AtomicLong)reservedMemory.get(null);
                DIRECT_MEMORY_INSPECTOR = DirectMemoryInspector.AtomicLong;
            } else {
                reservedMemoryAtomicLong = null;
                DIRECT_MEMORY_INSPECTOR = DirectMemoryInspector.Reflect;
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    static enum DirectMemoryInspector {
        Reflect{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long usedDirectMemory() {
                try {
                    Class clazz = bitsClass;
                    synchronized (clazz) {
                        return reservedMemory.getLong(null);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        ,
        AtomicLong{

            @Override
            public long usedDirectMemory() {
                return reservedMemoryAtomicLong.get();
            }
        };


        public abstract long usedDirectMemory();
    }
}

