/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.latencybenchmark;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.affinity.Affinity;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.latencybenchmark.LatencyTask;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.core.util.NanoSampler;

public class LatencyTestHarness {
    public static final Double[] NO_DOUBLES = new Double[0];
    private final Map<String, Histogram> additionHistograms = new TreeMap<String, Histogram>();
    private int messageCount = -1;
    private int warmUp = 10000;
    private int throughput = 10000;
    private int rate = 1000000000 / this.throughput;
    private boolean accountForCoordinatedOmmission = true;
    private Histogram histogram = new Histogram();
    private Histogram osJitter = new Histogram();
    private int recordJitterGreaterThanNs = 1000;
    private int runs = 1;
    private LatencyTask latencyTask;
    private boolean recordOSJitter = true;
    private long noResultsReturned;
    private AtomicBoolean warmUpComplete = new AtomicBoolean(false);
    private boolean warmedUp;

    public LatencyTestHarness throughput(int throughput) {
        this.throughput = throughput;
        return this;
    }

    public LatencyTestHarness accountForCoordinatedOmmission(Boolean accountForCoordinatedOmmission) {
        this.accountForCoordinatedOmmission = accountForCoordinatedOmmission;
        return this;
    }

    public LatencyTestHarness recordJitterGreaterThanNs(int recordJitterGreaterThanNs) {
        this.recordJitterGreaterThanNs = recordJitterGreaterThanNs;
        return this;
    }

    public LatencyTestHarness recordOSJitter(boolean recordOSJitter) {
        this.recordOSJitter = recordOSJitter;
        return this;
    }

    public LatencyTestHarness warmUp(int warmUp) {
        this.warmUp = warmUp;
        return this;
    }

    public LatencyTestHarness runs(int runs) {
        this.runs = runs;
        return this;
    }

    public LatencyTestHarness messageCount(int messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    public LatencyTestHarness build(LatencyTask latencyTask) {
        if (this.messageCount == -1) {
            throw new IllegalStateException("messageCount must be set");
        }
        if (this.throughput == -1) {
            throw new IllegalStateException("throughput must be set");
        }
        this.latencyTask = latencyTask;
        this.rate = 1000000000 / this.throughput;
        return this;
    }

    public NanoSampler addProbe(String name) {
        return this.additionHistograms.computeIfAbsent(name, n -> new Histogram());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.latencyTask.init(this);
        OSJitterMonitor osJitterMonitor = new OSJitterMonitor();
        ArrayList<double[]> percentileRuns = new ArrayList<double[]>();
        HashMap additionalPercentileRuns = new HashMap();
        if (this.recordOSJitter) {
            osJitterMonitor.setDaemon(true);
            osJitterMonitor.start();
        }
        for (int i = 0; i < this.warmUp; ++i) {
            this.latencyTask.run(System.nanoTime());
        }
        AffinityLock lock = Affinity.acquireLock();
        try {
            for (int run = 0; run < this.runs; ++run) {
                long startTimeNs = System.nanoTime();
                for (int i = 0; i < this.messageCount; ++i) {
                    if (i == 0 && run == 0) {
                        while (!this.warmUpComplete.get()) {
                            Thread.yield();
                        }
                        Jvm.pause(100L);
                        startTimeNs = System.nanoTime();
                    } else if (this.accountForCoordinatedOmmission) {
                        startTimeNs += (long)this.rate;
                        while (System.nanoTime() < startTimeNs) {
                        }
                    } else {
                        Jvm.busyWaitMicros(this.rate / 1000);
                        startTimeNs = System.nanoTime();
                    }
                    this.latencyTask.run(startTimeNs);
                }
                while (this.histogram.totalCount() < (long)this.messageCount) {
                    Thread.yield();
                }
                percentileRuns.add(this.histogram.getPercentiles());
                System.out.println("-------------------------------- BENCHMARK RESULTS (RUN " + (run + 1) + ") --------------------------------------------------------");
                System.out.println("Correcting for co-ordinated:" + this.accountForCoordinatedOmmission);
                System.out.println("Target throughput:" + this.throughput + "/s" + " = 1 message every " + this.rate / 1000 + "us");
                System.out.println("TotalCount (whole run):" + this.histogram.totalCount());
                if (this.additionHistograms.size() > 0) {
                    this.additionHistograms.entrySet().stream().forEach(e -> System.out.println("TotalCount (" + (String)e.getKey() + "):" + ((Histogram)e.getValue()).totalCount()));
                }
                System.out.printf("%-40s", "whole run:");
                System.out.println(this.histogram.toMicrosFormat());
                if (this.additionHistograms.size() > 0) {
                    this.additionHistograms.entrySet().stream().forEach(e -> {
                        List ds = additionalPercentileRuns.computeIfAbsent(e.getKey(), i -> new ArrayList());
                        ds.add(((Histogram)e.getValue()).getPercentiles());
                        System.out.printf("%-40s", (String)e.getKey() + ":");
                        System.out.println(((Histogram)e.getValue()).toMicrosFormat());
                    });
                }
                if (this.recordOSJitter) {
                    System.out.printf("%-40s", "OS Jitter:");
                    System.out.println(this.osJitter.toMicrosFormat());
                }
                System.out.println("-------------------------------------------------------------------------------------------------------------------");
                this.noResultsReturned = 0L;
                this.histogram.reset();
                this.additionHistograms.values().stream().forEach(Histogram::reset);
                osJitterMonitor.reset();
            }
        }
        finally {
            Jvm.pause(5L);
            lock.release();
            Jvm.pause(5L);
        }
        this.printPercentilesSummary("whole run", percentileRuns);
        if (additionalPercentileRuns.size() > 0) {
            additionalPercentileRuns.entrySet().stream().forEach(e -> this.printPercentilesSummary((String)e.getKey(), (List)e.getValue()));
        }
        this.latencyTask.complete();
    }

    public void printPercentilesSummary(String label, List<double[]> percentileRuns) {
        System.out.println("-------------------------------- SUMMARY (" + label + ")------------------------------------------------------------");
        ArrayList<Double> consistencies = new ArrayList<Double>();
        double maxValue = Double.MIN_VALUE;
        double minValue = Double.MAX_VALUE;
        for (int i = 0; i < percentileRuns.get(0).length; ++i) {
            double total_log = 0.0;
            for (double[] percentileRun : percentileRuns) {
                double v = percentileRun[i];
                if (v > maxValue) {
                    maxValue = v;
                }
                if (v < minValue) {
                    minValue = v;
                }
                total_log += Math.log10(v);
            }
            consistencies.add(100.0 * (maxValue - minValue) / (maxValue + minValue / 2.0));
            double avg_log = total_log / (double)percentileRuns.size();
            double total_sqr_log = 0.0;
            for (double[] percentileRun : percentileRuns) {
                double v = percentileRun[i];
                double logv = Math.log10(v);
                total_sqr_log += (logv - avg_log) * (logv - avg_log);
            }
            double var_log = total_sqr_log / (double)(percentileRuns.size() - 1);
            consistencies.add(var_log);
            maxValue = Double.MIN_VALUE;
            minValue = Double.MAX_VALUE;
        }
        ArrayList<Double> summary = new ArrayList<Double>();
        for (int i = 0; i < percentileRuns.get(0).length; ++i) {
            for (double[] percentileRun : percentileRuns) {
                summary.add(percentileRun[i] / 1000.0);
            }
            summary.add((Double)consistencies.get(i * 2));
            summary.add((Double)consistencies.get(i * 2 + 1));
        }
        StringBuilder sb = new StringBuilder();
        this.addHeaderToPrint(sb, this.runs);
        System.out.println(sb.toString());
        sb = new StringBuilder();
        this.addPrToPrint(sb, "50:   ", this.runs);
        this.addPrToPrint(sb, "90:   ", this.runs);
        this.addPrToPrint(sb, "99:   ", this.runs);
        this.addPrToPrint(sb, "99.9: ", this.runs);
        this.addPrToPrint(sb, "99.99:", this.runs);
        this.addPrToPrint(sb, "worst:", this.runs);
        System.out.printf(sb.toString(), summary.toArray(NO_DOUBLES));
        System.out.println("-------------------------------------------------------------------------------------------------------------------");
    }

    private void addPrToPrint(StringBuilder sb, String pr, int runs) {
        sb.append(pr);
        for (int i = 0; i < runs; ++i) {
            sb.append("%12.2f ");
        }
        sb.append("%12.2f");
        sb.append("%12.2f");
        sb.append("%n");
    }

    private void addHeaderToPrint(StringBuilder sb, int runs) {
        sb.append("Percentile");
        for (int i = 1; i < runs + 1; ++i) {
            if (i == 1) {
                sb.append("   run" + i);
                continue;
            }
            sb.append("         run" + i);
        }
        sb.append("      % Variation");
        sb.append("   var(log)");
    }

    public void sample(long nanoTime) {
        ++this.noResultsReturned;
        if (this.noResultsReturned < (long)this.warmUp && !this.warmedUp) {
            this.histogram.sample(nanoTime);
            return;
        }
        if (this.noResultsReturned == (long)this.warmUp && !this.warmedUp) {
            this.warmedUp = true;
            this.histogram.reset();
            if (this.additionHistograms.size() > 0) {
                this.additionHistograms.values().forEach(Histogram::reset);
            }
            this.warmUpComplete.set(true);
            System.out.println("Warm up complete");
            return;
        }
        this.histogram.sample(nanoTime);
    }

    class OSJitterMonitor
    extends Thread {
        final AtomicBoolean reset = new AtomicBoolean(false);

        OSJitterMonitor() {
        }

        @Override
        public void run() {
            Affinity.setAffinity((BitSet)AffinityLock.BASE_AFFINITY);
            long lastTime = System.nanoTime();
            while (true) {
                long time;
                if (this.reset.get()) {
                    this.reset.set(false);
                    LatencyTestHarness.this.osJitter.reset();
                    lastTime = System.nanoTime();
                }
                if ((time = System.nanoTime()) - lastTime > (long)LatencyTestHarness.this.recordJitterGreaterThanNs) {
                    LatencyTestHarness.this.osJitter.sample(time - lastTime);
                }
                lastTime = time;
            }
        }

        public void reset() {
            this.reset.set(true);
        }
    }
}

