/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.tcp;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.tcp.FastJ8SocketChannel;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOStatus;

public class UnsafeFastJ8SocketChannel
extends FastJ8SocketChannel {
    UnsafeFastJ8SocketChannel(SocketChannel socketChannel) {
        super(socketChannel);
    }

    @Override
    int read0(ByteBuffer buf) throws IOException {
        if (!this.isOpen()) {
            return -1;
        }
        return this.readInternal(buf);
    }

    @Override
    public int write(ByteBuffer buf) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (this.isBlocking() || !this.isOpen() || !(buf instanceof DirectBuffer)) {
            return super.write(buf);
        }
        if (!this.isOpen()) {
            return -1;
        }
        return this.writeInternal(buf);
    }

    private int writeInternal(ByteBuffer buf) throws IOException {
        int pos = buf.position();
        int lim = buf.limit();
        int len = lim <= pos ? 0 : lim - pos;
        int res = OS.write0(this.fd, ((DirectBuffer)((Object)buf)).address() + (long)pos, len);
        if (res > 0) {
            buf.position(pos + res);
        }
        if (res == -3 && this.socketChannel.isOpen()) {
            return 0;
        }
        if ((res = IOStatus.normalize(res)) < 0) {
            this.open = false;
        }
        if (res <= 0 && !this.socketChannel.isOpen()) {
            throw new AsynchronousCloseException();
        }
        return res;
    }
}

