/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WeakReferenceCleaner
extends WeakReference<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WeakReferenceCleaner.class);
    private static final ReferenceQueue<Object> REFERENCE_QUEUE = new ReferenceQueue();
    private static final Map<WeakReferenceCleaner, Boolean> REFERENCE_MAP = new ConcurrentHashMap<WeakReferenceCleaner, Boolean>();
    private static final AtomicBoolean REFERENCE_PROCESSOR_STARTED = new AtomicBoolean(false);
    private static final AtomicIntegerFieldUpdater<WeakReferenceCleaner> CLEANED_FLAG = AtomicIntegerFieldUpdater.newUpdater(WeakReferenceCleaner.class, "cleaned");
    private final Runnable thunk;
    private volatile int cleaned = 0;

    private WeakReferenceCleaner(Object referent, Runnable thunk) {
        super(referent, REFERENCE_QUEUE);
        this.thunk = thunk;
    }

    public void clean() {
        if (CLEANED_FLAG.compareAndSet(this, 0, 1)) {
            this.thunk.run();
        }
    }

    public static WeakReferenceCleaner newCleaner(Object referent, Runnable thunk) {
        WeakReferenceCleaner.startReferenceProcessor(WeakReferenceCleaner::referenceCleanerExecutor);
        WeakReferenceCleaner cleaner = new WeakReferenceCleaner(referent, thunk);
        REFERENCE_MAP.put(cleaner, Boolean.TRUE);
        return cleaner;
    }

    public static void startReferenceProcessor(Supplier<Executor> executorSupplier) {
        if (!REFERENCE_PROCESSOR_STARTED.get() && REFERENCE_PROCESSOR_STARTED.compareAndSet(false, true)) {
            executorSupplier.get().execute(new ReferenceProcessor());
        }
    }

    private static Executor referenceCleanerExecutor() {
        return Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r);
            t.setName("chronicle-weak-reference-cleaner");
            t.setDaemon(true);
            return t;
        });
    }

    private static final class ReferenceProcessor
    implements Runnable {
        private ReferenceProcessor() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Reference reference = REFERENCE_QUEUE.remove(100L);
                    if (reference == null) continue;
                    WeakReferenceCleaner cleaner = (WeakReferenceCleaner)reference;
                    try {
                        cleaner.thunk.run();
                    }
                    finally {
                        REFERENCE_MAP.remove(cleaner);
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.warn("Interrupted while trying to retrieve reference, exiting.", (Throwable)e);
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (RuntimeException e) {
                    LOGGER.warn("Exception while trying to process reference.", (Throwable)e);
                }
            }
        }
    }
}

