/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.concurrent.locks.LockSupport;

public enum Jvm {

    public static final boolean IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp") || Boolean.getBoolean("debug");

    public static <T extends Throwable> RuntimeException rethrow(Throwable throwable) throws T {
        throw throwable;
    }

    public static void trimStackTrace(StringBuilder sb, StackTraceElement ... stes) {
        int first = Jvm.trimFirst(stes);
        int last = Jvm.trimLast(first, stes);
        for (int i = first; i <= last; ++i) {
            sb.append("\n\tat ").append(stes[i]);
        }
    }

    static int trimFirst(StackTraceElement[] stes) {
        int first;
        for (first = 0; first < stes.length && Jvm.isInternal(stes[first].getClassName()); ++first) {
        }
        return Math.max(0, first - 2);
    }

    public static int trimLast(int first, StackTraceElement[] stes) {
        int last;
        for (last = stes.length - 1; first < last && Jvm.isInternal(stes[last].getClassName()); --last) {
        }
        if (last < stes.length - 1) {
            ++last;
        }
        return last;
    }

    static boolean isInternal(String className) {
        return className.startsWith("jdk.") || className.startsWith("sun.") || className.startsWith("java.");
    }

    public static boolean isDebug() {
        return IS_DEBUG;
    }

    public static void pause(long millis) {
        long timeNanos = millis * 1000000L;
        if ((double)timeNanos > 1.0E9) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        } else {
            LockSupport.parkNanos(timeNanos);
        }
    }

    public static void busyWaitMicros(long micros) {
        long waitUntil = System.nanoTime() + micros * 1000L;
        while (waitUntil > System.nanoTime()) {
        }
    }

    public static Field getField(Class clazz, String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            Class superclass = clazz.getSuperclass();
            if (superclass != null) {
                try {
                    return Jvm.getField(superclass, name);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new AssertionError((Object)e);
        }
    }
}

