/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import net.openhft.chronicle.core.annotation.ForceInline;
import org.jetbrains.annotations.NotNull;

public enum StringUtils {

    private static final Constructor<String> STRING_CONSTRUCTOR;
    private static final Field S_VALUE;
    private static final Field SB_VALUE;
    private static final Field SB_COUNT;

    public static boolean endsWith(@NotNull CharSequence source, @NotNull String endsWith) {
        for (int i = 1; i <= endsWith.length(); ++i) {
            if (Character.toLowerCase(source.charAt(source.length() - i)) == Character.toLowerCase(endsWith.charAt(endsWith.length() - i))) continue;
            return false;
        }
        return true;
    }

    @ForceInline
    public static boolean isEqual(CharSequence s, CharSequence cs) {
        if (s == null) {
            return false;
        }
        if (s.length() != cs.length()) {
            return false;
        }
        for (int i = 0; i < cs.length(); ++i) {
            if (s.charAt(i) == cs.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @ForceInline
    public static boolean equalsCaseIgnore(CharSequence s, CharSequence cs) {
        if (s == null) {
            return false;
        }
        if (s.length() != cs.length()) {
            return false;
        }
        for (int i = 0; i < cs.length(); ++i) {
            if (Character.toLowerCase(s.charAt(i)) == Character.toLowerCase(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @ForceInline
    public static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    public static char[] extractChars(StringBuilder sb) {
        try {
            return (char[])SB_VALUE.get(sb);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static char[] extractChars(String s) {
        try {
            return (char[])S_VALUE.get(s);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void setCount(StringBuilder sb, int count) {
        try {
            SB_COUNT.setInt(sb, count);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String newString(char[] chars) {
        try {
            return STRING_CONSTRUCTOR.newInstance(chars, true);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        try {
            STRING_CONSTRUCTOR = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
            STRING_CONSTRUCTOR.setAccessible(true);
            S_VALUE = String.class.getDeclaredField("value");
            S_VALUE.setAccessible(true);
            SB_VALUE = Class.forName("java.lang.AbstractStringBuilder").getDeclaredField("value");
            SB_VALUE.setAccessible(true);
            SB_COUNT = Class.forName("java.lang.AbstractStringBuilder").getDeclaredField("count");
            SB_COUNT.setAccessible(true);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

