/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.pool;

import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.util.StringUtils;

public class StringInterner {
    protected final String[] interner;
    protected final int mask;

    public StringInterner(int capacity) {
        int n = Maths.nextPower2(capacity, 128);
        this.interner = new String[n];
        this.mask = n - 1;
    }

    public String intern(CharSequence cs) {
        String s2;
        int h = Maths.hash(cs) & this.mask;
        String s = this.interner[h];
        if (StringUtils.isEqual(s, cs)) {
            return s;
        }
        this.interner[h] = s2 = cs.toString();
        return this.interner[h];
    }
}

