/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

public enum Maths {

    private static final double WHOLE_NUMBER = 9.007199254740992E15;

    public static double round2(double d) {
        double factor = 100.0;
        return d > 9.007199254740992E15 || d < -9.007199254740992E15 ? d : (double)((long)(d < 0.0 ? d * 100.0 - 0.5 : d * 100.0 + 0.5)) / 100.0;
    }

    public static double round4(double d) {
        double factor = 10000.0;
        return d > 9.223372036854776E14 || d < -9.223372036854776E14 ? d : (double)((long)(d < 0.0 ? d * 10000.0 - 0.5 : d * 10000.0 + 0.5)) / 10000.0;
    }

    public static double round6(double d) {
        double factor = 1000000.0;
        return d > 9.223372036854775E12 || d < -9.223372036854775E12 ? d : (double)((long)(d < 0.0 ? d * 1000000.0 - 0.5 : d * 1000000.0 + 0.5)) / 1000000.0;
    }

    public static double round8(double d) {
        double factor = 1.0E8;
        return d > 9.223372036854776E10 || d < -9.223372036854776E10 ? d : (double)((long)(d < 0.0 ? d * 1.0E8 - 0.5 : d * 1.0E8 + 0.5)) / 1.0E8;
    }

    public static int nextPower2(int n, int min) {
        return (int)Math.min(0x40000000L, Maths.nextPower2((long)n, (long)min));
    }

    public static long nextPower2(long n, long min) {
        if (!Maths.isPowerOf2(min)) {
            throw new IllegalArgumentException();
        }
        if (n < min) {
            return min;
        }
        if (Maths.isPowerOf2(n)) {
            return n;
        }
        long i = min;
        while (i < n) {
            if ((i *= 2L) > 0L) continue;
            return 0x4000000000000000L;
        }
        return i;
    }

    static boolean isPowerOf2(long n) {
        return n != 0L && (n & n - 1L) == 0L;
    }

    public static int hash(CharSequence cs) {
        long h = Maths.longHash(cs);
        return (int)(h ^ h >> 32);
    }

    public static long longHash(CharSequence cs) {
        long hash = 0L;
        for (int i = 0; i < cs.length(); ++i) {
            hash = Long.rotateLeft(hash, 7) + (long)cs.charAt(i);
        }
        return Maths.longHash(hash);
    }

    public static int intLog2(long num) {
        long l = Double.doubleToRawLongBits(num);
        return (int)((l >> 52) - 1023L);
    }

    public static byte toInt8(long x) {
        if ((long)((byte)x) == x) {
            return (byte)x;
        }
        throw new IllegalArgumentException("Byte " + x + " out of range");
    }

    public static short toInt16(long x) {
        if ((long)((short)x) == x) {
            return (short)x;
        }
        throw new IllegalArgumentException("Short " + x + " out of range");
    }

    public static int toInt32(long x, String msg) {
        if ((long)((int)x) == x) {
            return (int)x;
        }
        throw new IllegalArgumentException(String.format(msg, x));
    }

    public static int toInt32(long x) {
        if ((long)((int)x) == x) {
            return (int)x;
        }
        throw new IllegalArgumentException("Int " + x + " out of range");
    }

    public static short toUInt8(long x) {
        if ((x & 0xFFL) == x) {
            return (short)x;
        }
        throw new IllegalArgumentException("Unsigned Byte " + x + " out of range");
    }

    public static int toUInt16(long x) {
        if ((x & 0xFFFFL) == x) {
            return (int)x;
        }
        throw new IllegalArgumentException("Unsigned Short " + x + " out of range");
    }

    public static int toUInt31(long x) {
        if ((x & Integer.MAX_VALUE) == x) {
            return (int)x;
        }
        throw new IllegalArgumentException("Unsigned Int 31-bit " + x + " out of range");
    }

    public static long toUInt32(long x) {
        if ((x & 0xFFFFFFFFL) == x) {
            return x;
        }
        throw new IllegalArgumentException("Unsigned Int " + x + " out of range");
    }

    public static long agitate(long l) {
        l ^= l >> 23;
        l += Long.rotateRight(l, 18);
        return l;
    }

    public static long longHash(long l) {
        long h0 = -7826470488L + l * 1228037679L;
        long h1 = (l >> 32) * 846538563L;
        return Maths.agitate(h0) ^ Maths.agitate(h1);
    }
}

