/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.lang.management.ManagementFactory;

public enum Jvm {

    public static final boolean IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");

    public static <T extends Throwable> RuntimeException rethrow(Throwable t) throws T {
        throw t;
    }

    public static void trimStackTrace(StringBuilder sb, StackTraceElement ... stes) {
        int first = Jvm.trimFirst(stes);
        int last = Jvm.trimLast(first, stes);
        for (int i = first; i <= last; ++i) {
            sb.append("\n\tat ").append(stes[i]);
        }
    }

    static int trimFirst(StackTraceElement[] stes) {
        int first;
        for (first = 0; first < stes.length && Jvm.isInternal(stes[first].getClassName()); ++first) {
        }
        return Math.max(0, first - 2);
    }

    public static int trimLast(int first, StackTraceElement[] stes) {
        int last;
        for (last = stes.length - 1; first < last && Jvm.isInternal(stes[last].getClassName()); --last) {
        }
        if (last < stes.length - 1) {
            ++last;
        }
        return last;
    }

    static boolean isInternal(String className) {
        return className.startsWith("jdk.") || className.startsWith("sun.") || className.startsWith("java.");
    }

    public static boolean isDebug() {
        return IS_DEBUG;
    }

    public static void pause(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }
}

