/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.util.Random;
import java.util.Scanner;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.ReferenceCounted;
import net.openhft.chronicle.core.UnsafeMemory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Cleaner;
import sun.nio.ch.FileChannelImpl;

public class OS {
    public static final String TMP = System.getProperty("java.io.tmpdir");
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final int MAP_PV = 2;
    private static final boolean IS64BIT = net.openhft.chronicle.core.OS.is64Bit0();
    private static final Logger LOG = LoggerFactory.getLogger(OS.class);
    private static final int PROCESS_ID = net.openhft.chronicle.core.OS.getProcessId0();
    private static final Memory MEMORY;
    private static final String OS;
    private static final boolean IS_LINUX;
    private static final boolean IS_MAC;
    private static final boolean IS_WIN;
    private static boolean IS_DEBUG;
    public static final int MAP_ALIGNMENT;

    public static Memory memory() {
        return MEMORY;
    }

    public static int pageSize() {
        return net.openhft.chronicle.core.OS.memory().pageSize();
    }

    public static int mapAlignment() {
        return MAP_ALIGNMENT;
    }

    public static long mapAlign(long size) {
        int chunkMultiple = net.openhft.chronicle.core.OS.mapAlignment();
        return (size + (long)chunkMultiple - 1L) / (long)chunkMultiple * (long)chunkMultiple;
    }

    public static boolean is64Bit() {
        return IS64BIT;
    }

    private static boolean is64Bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    public static int getProcessId() {
        return PROCESS_ID;
    }

    private static int getProcessId0() {
        String pid = null;
        File self = new File("/proc/self");
        try {
            if (self.exists()) {
                pid = self.getCanonicalFile().getName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pid == null) {
            pid = ManagementFactory.getRuntimeMXBean().getName().split("@", 0)[0];
        }
        if (pid == null) {
            int rpid = new Random().nextInt(65536);
            LOG.warn("Unable to determine PID, picked a random number=" + rpid);
            return rpid;
        }
        return Integer.parseInt(pid);
    }

    public static boolean isWindows() {
        return IS_WIN;
    }

    public static boolean isMacOSX() {
        return IS_MAC;
    }

    public static boolean isLinux() {
        return IS_LINUX;
    }

    public static long getPidMax() {
        if (net.openhft.chronicle.core.OS.isLinux()) {
            File file = new File("/proc/sys/kernel/pid_max");
            if (file.canRead()) {
                try {
                    return Maths.nextPower2(new Scanner(file).nextLong(), 1L);
                }
                catch (FileNotFoundException e) {
                    LOG.warn("", (Throwable)e);
                }
            }
        } else if (net.openhft.chronicle.core.OS.isMacOSX()) {
            return 0x1000000L;
        }
        return 65536L;
    }

    private static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static long freePhysicalMemoryOnWindowsInBytes() throws IOException {
        if (!net.openhft.chronicle.core.OS.isWindows()) {
            throw new IllegalStateException("Method freePhysicalMemoryOnWindowsInBytes() should be called only on windows. Use Jvm.isWindows() to check the OS.");
        }
        Process pr = Runtime.getRuntime().exec("wmic OS get FreePhysicalMemory /Value < NUL");
        try {
            int result = pr.waitFor();
            String output = net.openhft.chronicle.core.OS.convertStreamToString(pr.getInputStream());
            if (result != 0) {
                String errorOutput = net.openhft.chronicle.core.OS.convertStreamToString(pr.getErrorStream());
                throw new IOException("Couldn't get free physical memory on windows. Command \"wmic OS get FreePhysicalMemory /Value\" exited with " + result + " code, putput: \"" + output + "\", error output: \"" + errorOutput + "\"");
            }
            String[] parts = output.trim().split("=");
            if (parts.length != 2) {
                throw new IOException("Couldn't get free physical memory on windows. Command \"wmic OS get FreePhysicalMemory /Value\" output has unexpected format: \"" + output + "\"");
            }
            try {
                return Long.parseLong(parts[1]) * 1024L;
            }
            catch (NumberFormatException e) {
                throw new IOException("Couldn't get free physical memory on windows. Command \"wmic OS get FreePhysicalMemory /Value\" output has unexpected format: \"" + output + "\"", e);
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public static long map(FileChannel fileChannel, FileChannel.MapMode mode, long start, long size) throws IOException {
        try {
            return net.openhft.chronicle.core.OS.map0(fileChannel, net.openhft.chronicle.core.OS.imodeFor(mode), start, size);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw net.openhft.chronicle.core.OS.wrap(e);
        }
    }

    private static long map0(FileChannel fileChannel, int imode, long start, long size) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method map0 = fileChannel.getClass().getDeclaredMethod("map0", Integer.TYPE, Long.TYPE, Long.TYPE);
        map0.setAccessible(true);
        return (Long)map0.invoke((Object)fileChannel, imode, start, size);
    }

    public static void unmap(long address, long size) throws IOException {
        try {
            Method unmap0 = FileChannelImpl.class.getDeclaredMethod("unmap0", Long.TYPE, Long.TYPE);
            unmap0.setAccessible(true);
            unmap0.invoke(null, address, size);
        }
        catch (Exception e) {
            throw net.openhft.chronicle.core.OS.wrap(e);
        }
    }

    private static IOException wrap(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = e.getCause();
        }
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException(e);
    }

    private static int imodeFor(FileChannel.MapMode mode) {
        int imode = -1;
        if (mode == FileChannel.MapMode.READ_ONLY) {
            imode = 0;
        } else if (mode == FileChannel.MapMode.READ_WRITE) {
            imode = 1;
        } else if (mode == FileChannel.MapMode.PRIVATE) {
            imode = 2;
        }
        assert (imode >= 0);
        return imode;
    }

    public static Cleaner cleanerFor(ReferenceCounted owner, long address, long size) {
        return Cleaner.create((Object)owner, (Runnable)new Unmapper(address, size, owner));
    }

    public static boolean isDebug() {
        return IS_DEBUG;
    }

    static {
        OS = System.getProperty("os.name").toLowerCase();
        IS_LINUX = OS.startsWith("linux");
        IS_MAC = OS.contains("mac");
        IS_WIN = OS.startsWith("win");
        IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
        Memory memory = null;
        try {
            Class<Memory> java9MemoryClass = Class.forName("software.chronicle.enterprise.core.Java9Memory").asSubclass(Memory.class);
            Method create = java9MemoryClass.getMethod("create", new Class[0]);
            memory = (Memory)create.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException java9MemoryClass) {
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.warn("Unable to load Java9MemoryClass", (Throwable)e);
        }
        if (memory == null) {
            memory = UnsafeMemory.create();
        }
        MEMORY = memory;
        MAP_ALIGNMENT = net.openhft.chronicle.core.OS.isWindows() ? 65536 : net.openhft.chronicle.core.OS.pageSize();
    }

    public static class Unmapper
    implements Runnable {
        private final long size;
        private final ReferenceCounted owner;
        private volatile long address;

        public Unmapper(long address, long size, ReferenceCounted owner) {
            owner.reserve();
            this.owner = owner;
            assert (address != 0L);
            this.address = address;
            this.size = size;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            try {
                net.openhft.chronicle.core.OS.unmap(this.address, this.size);
                this.address = 0L;
                this.owner.release();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

