/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.algo;

import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.algo.BytesStoreHash;
import net.openhft.chronicle.core.annotation.NonNegative;

public class XxHash
implements BytesStoreHash<BytesStore<?, ?>> {
    private static final long P1 = -7046029288634856825L;
    private static final long P2 = -4417276706812531889L;
    private static final long P3 = 1609587929392839161L;
    private static final long P4 = -8796714831421723037L;
    private static final long P5 = 2870177450012600261L;
    public static final XxHash INSTANCE = new XxHash(-8796714831421723037L);
    private final long seed;

    public XxHash(long seed) {
        this.seed = seed;
    }

    private static long finishUp(long hash) {
        hash ^= hash >>> 33;
        hash *= -4417276706812531889L;
        hash ^= hash >>> 29;
        hash *= 1609587929392839161L;
        hash ^= hash >>> 32;
        return hash;
    }

    long fetch64(BytesStore<?, ?> bytes, @NonNegative long off) throws IllegalStateException, BufferUnderflowException {
        return bytes.readLong(off);
    }

    long fetch32(BytesStore<?, ?> bytes, @NonNegative long off) throws IllegalStateException, BufferUnderflowException {
        return bytes.readUnsignedInt(off);
    }

    long fetch8(BytesStore<?, ?> bytes, @NonNegative long off) throws IllegalStateException, BufferUnderflowException {
        return bytes.readUnsignedByte(off);
    }

    @Override
    public long applyAsLong(BytesStore<?, ?> bytes) {
        return this.applyAsLong(bytes, bytes.readRemaining());
    }

    @Override
    public long applyAsLong(BytesStore<?, ?> bytes, @NonNegative long length) throws IllegalStateException, BufferUnderflowException {
        long hash;
        long remaining = length;
        if (remaining < 0L || length > bytes.readRemaining()) {
            throw new BufferUnderflowException();
        }
        long off = bytes.readPosition();
        if (remaining >= 32L) {
            long v1 = this.seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = this.seed + -4417276706812531889L;
            long v3 = this.seed;
            long v4 = this.seed - -7046029288634856825L;
            do {
                v1 += this.fetch64(bytes, off) * -4417276706812531889L;
                v1 = Long.rotateLeft(v1, 31);
                v1 *= -7046029288634856825L;
                v2 += this.fetch64(bytes, off + 8L) * -4417276706812531889L;
                v2 = Long.rotateLeft(v2, 31);
                v2 *= -7046029288634856825L;
                v3 += this.fetch64(bytes, off + 16L) * -4417276706812531889L;
                v3 = Long.rotateLeft(v3, 31);
                v3 *= -7046029288634856825L;
                v4 += this.fetch64(bytes, off + 24L) * -4417276706812531889L;
                v4 = Long.rotateLeft(v4, 31);
                v4 *= -7046029288634856825L;
                off += 32L;
            } while ((remaining -= 32L) >= 32L);
            hash = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            v1 *= -4417276706812531889L;
            v1 = Long.rotateLeft(v1, 31);
            hash ^= (v1 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v2 *= -4417276706812531889L;
            v2 = Long.rotateLeft(v2, 31);
            hash ^= (v2 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v3 *= -4417276706812531889L;
            v3 = Long.rotateLeft(v3, 31);
            hash ^= (v3 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v4 *= -4417276706812531889L;
            v4 = Long.rotateLeft(v4, 31);
            hash ^= (v4 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
        } else {
            hash = this.seed + 2870177450012600261L;
        }
        hash += length;
        while (remaining >= 8L) {
            long k1 = this.fetch64(bytes, off);
            k1 *= -4417276706812531889L;
            k1 = Long.rotateLeft(k1, 31);
            hash ^= (k1 *= -7046029288634856825L);
            hash = Long.rotateLeft(hash, 27) * -7046029288634856825L + -8796714831421723037L;
            off += 8L;
            remaining -= 8L;
        }
        if (remaining >= 4L) {
            hash ^= this.fetch32(bytes, off) * -7046029288634856825L;
            hash = Long.rotateLeft(hash, 23) * -4417276706812531889L + 1609587929392839161L;
            off += 4L;
            remaining -= 4L;
        }
        while (remaining != 0L) {
            hash ^= this.fetch8(bytes, off) * 2870177450012600261L;
            hash = Long.rotateLeft(hash, 11) * -7046029288634856825L;
            --remaining;
            ++off;
        }
        return XxHash.finishUp(hash);
    }
}

