/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.AbstractBytes;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.SubBytes;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.internal.NativeBytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.ThreadingIllegalStateException;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaBytes<U>
extends AbstractBytes<U>
implements Byteable,
Comparable<CharSequence> {
    protected VanillaBytes(@NotNull BytesStore<?, ?> bytesStore) throws ClosedIllegalStateException, IllegalArgumentException, ThreadingIllegalStateException {
        this(bytesStore, bytesStore.writePosition(), bytesStore.writeLimit());
    }

    protected VanillaBytes(@NotNull BytesStore<?, ?> bytesStore, long writePosition, long writeLimit) throws ClosedIllegalStateException, IllegalArgumentException, ThreadingIllegalStateException {
        super((BytesStore)Jvm.uncheckedCast(bytesStore), writePosition, writeLimit);
    }

    public static <U> VanillaBytes<U> wrap(BytesStore<?, U> bytesStore) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        return new VanillaBytes<U>(bytesStore);
    }

    @NotNull
    public static VanillaBytes<Void> vanillaBytes() {
        return new NativeBytes<Void>(BytesStore.empty());
    }

    private static boolean isEqual0(byte[] bytes, byte coder, @NotNull NativeBytesStore bs, long address) {
        @Nullable Memory memory = bs.memory;
        if (coder == 0) {
            for (int i = 0; i < bytes.length; ++i) {
                char c;
                byte b = memory.readByte(address + (long)i);
                if (b == (c = (char)(bytes[i] & 0xFF))) continue;
                return false;
            }
        } else {
            for (int i = 0; i < bytes.length; ++i) {
                char c;
                byte b = memory.readByte(address + (long)i);
                if (b == (c = (char)((bytes[i + 1] & 0xFF) << 8 | bytes[i] & 0xFF))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isEqual0(char[] chars, @NotNull NativeBytesStore bs, long address) {
        int b;
        int i;
        @Nullable Memory memory = bs.memory;
        for (i = 0; i < chars.length - 3; i += 4) {
            b = memory.readInt(address + (long)i);
            int b0 = b & 0xFF;
            int b1 = b >> 8 & 0xFF;
            int b2 = b >> 16 & 0xFF;
            int b3 = b >> 24 & 0xFF;
            if (b0 == chars[i] && b1 == chars[i + 1] && b2 == chars[i + 2] && b3 == chars[i + 3]) continue;
            return false;
        }
        while (i < chars.length) {
            b = memory.readByte(address + (long)i) & 0xFF;
            if (b != chars[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isEqual1(char[] chars, @NotNull BytesStore<?, ?> bytesStore, @NonNegative long readPosition) throws BufferUnderflowException {
        for (int i = 0; i < chars.length; ++i) {
            int b = bytesStore.readByte(readPosition + (long)i) & 0xFF;
            if (b == chars[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean isEqual1(byte[] bytes, byte coder, @NotNull BytesStore<?, ?> bytesStore, @NonNegative long readPosition) throws BufferUnderflowException {
        for (int i = 0; i < bytes.length; ++i) {
            char c;
            int b = bytesStore.readByte(readPosition + (long)i) & 0xFF;
            if (coder == 0) {
                c = (char)(bytes[i] & 0xFF);
            } else {
                c = (char)((bytes[i + 1] & 0xFF) << 8 | bytes[i] & 0xFF);
                ++i;
            }
            if (b == c) continue;
            return false;
        }
        return true;
    }

    @Override
    public long readVolatileLong(@NonNegative long offset) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        this.readCheckOffset(offset, 8L, true);
        return this.bytesStore.readVolatileLong(offset);
    }

    @Override
    public void bytesStore(@NotNull BytesStore byteStore, @NonNegative long offset, @NonNegative long length) throws ClosedIllegalStateException, IllegalArgumentException, BufferUnderflowException, ThreadingIllegalStateException {
        ObjectUtils.requireNonNull((Object)byteStore);
        this.setBytesStore(byteStore);
        this.readLimit(offset + length);
        this.readPosition(offset);
        this.writeLimit(offset + length);
    }

    private void setBytesStore(@NotNull BytesStore<?, U> bytesStore) throws ClosedIllegalStateException, IllegalArgumentException, ThreadingIllegalStateException {
        if (this.bytesStore != bytesStore) {
            @Nullable BytesStore oldBS = this.bytesStore;
            this.bytesStore(bytesStore);
            bytesStore.reserve((ReferenceOwner)this);
            oldBS.release((ReferenceOwner)this);
        }
        this.clear();
    }

    @Override
    public long offset() {
        return this.readPosition();
    }

    @Override
    public long maxSize() {
        return this.readRemaining();
    }

    @Override
    public boolean isElastic() {
        return false;
    }

    @Override
    @NotNull
    public Bytes<U> bytesForRead() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.throwExceptionIfReleased();
        return this.isClear() ? new VanillaBytes<U>((BytesStore<?, ?>)this.bytesStore, this.writePosition(), this.bytesStore.writeLimit()) : new SubBytes((BytesStore<?, ?>)this.bytesStore, this.readPosition(), this.readLimit());
    }

    @Override
    public boolean isEqual(@Nullable String other) {
        if (other == null || (long)other.length() != this.readRemaining()) {
            return false;
        }
        AbstractBytes.ReportUnoptimised.reportOnce();
        long realLength = this.realReadRemaining();
        if (Jvm.isJava9Plus() && Jvm.maxDirectMemory() > 0L) {
            byte[] bytes = StringUtils.extractBytes((String)other);
            byte coder = StringUtils.getStringCoder((String)other);
            if (this.bytesStore instanceof NativeBytesStore && realLength == this.readRemaining()) {
                @NotNull NativeBytesStore bs = (NativeBytesStore)this.bytesStore;
                long address = bs.addressForRead(this.readPosition);
                return VanillaBytes.isEqual0(bytes, coder, bs, address);
            }
            return VanillaBytes.isEqual1(bytes, coder, this.bytesStore, this.readPosition);
        }
        char[] chars = StringUtils.extractChars((String)other);
        if (this.bytesStore instanceof NativeBytesStore && realLength == this.readRemaining()) {
            @NotNull NativeBytesStore bs = (NativeBytesStore)this.bytesStore;
            long address = bs.addressForRead(this.readPosition);
            return VanillaBytes.isEqual0(chars, bs, address);
        }
        return VanillaBytes.isEqual1(chars, this.bytesStore, this.readPosition);
    }

    @Override
    @NonNegative
    public long realCapacity() {
        return this.bytesStore.realCapacity();
    }

    @Override
    public long findByte(byte stopByte) throws ClosedIllegalStateException {
        return BytesInternal.findByte(this, stopByte);
    }

    @Override
    public long parseLong() throws BufferUnderflowException, ClosedIllegalStateException {
        return BytesInternal.parseLong(this);
    }

    @Override
    @NotNull
    public BytesStore<Bytes<U>, U> copy() throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.throwExceptionIfReleased();
        AbstractBytes.ReportUnoptimised.reportOnce();
        if (this.bytesStore.underlyingObject() instanceof ByteBuffer) {
            ByteBuffer bb = ByteBuffer.allocateDirect(Maths.toInt32((long)this.readRemaining()));
            @NotNull ByteBuffer bbu = (ByteBuffer)this.bytesStore.underlyingObject();
            ByteBuffer slice = bbu.slice();
            slice.position((int)this.readPosition());
            slice.limit((int)this.readLimit());
            bb.put(slice);
            bb.clear();
            return (BytesStore)Jvm.uncheckedCast(BytesStore.wrap(bb));
        }
        return (BytesStore)Jvm.uncheckedCast(BytesUtil.copyOf(this));
    }

    protected void optimisedWrite(@NotNull RandomDataInput bytes, @NonNegative long offset, @NonNegative long length) throws BufferOverflowException, BufferUnderflowException, ClosedIllegalStateException, IllegalArgumentException, ThreadingIllegalStateException {
        ObjectUtils.requireNonNull((Object)bytes);
        if (length <= (long)this.safeCopySize() && this.isDirectMemory() && bytes.isDirectMemory()) {
            long len = Math.min(this.writeRemaining(), Math.min(bytes.capacity() - offset, length));
            if (len > 0L) {
                this.writeCheckOffset(this.writePosition(), len);
                long address = bytes.addressForRead(offset);
                long address2 = this.addressForWritePosition();
                assert (address != 0L);
                assert (address2 != 0L);
                OS.memory().copyMemory(address, address2, len);
                this.writeSkip(len);
            }
        } else {
            BytesInternal.writeFully(bytes, offset, length, this);
        }
    }

    public void write(long position, @NotNull CharSequence str, @NonNegative int offset, @NonNegative int length) throws BufferOverflowException, IllegalArgumentException, ArithmeticException, ClosedIllegalStateException, BufferUnderflowException, ThreadingIllegalStateException {
        ObjectUtils.requireNonNull((Object)str);
        if (((long)(offset | length) | position) < 0L) {
            Longs.requireNonNegative((long)position);
            Longs.requireNonNegative((long)offset);
            Longs.requireNonNegative((long)length);
        }
        this.ensureCapacity(this.writePosition() + (long)length);
        if (offset + length > str.length()) {
            throw new IllegalArgumentException("offset=" + offset + " + length=" + length + " > str.length =" + str.length());
        }
        for (int i = 0; i < length; ++i) {
            int index = offset + i;
            this.bytesStore.writeByte(position + (long)i, this.charAt(str, index));
        }
    }

    private char charAt(@NotNull CharSequence str, @NonNegative int index) {
        return str.charAt(index);
    }

    @Override
    @NotNull
    public VanillaBytes<U> append(@NotNull CharSequence str, @NonNegative int start, @NonNegative int end) throws IndexOutOfBoundsException {
        assert (end > start) : "end=" + end + ",start=" + start;
        ObjectUtils.requireNonNull((Object)str);
        try {
            if (this.isDirectMemory()) {
                if (str instanceof BytesStore) {
                    this.write((BytesStore)str, (long)start, (long)end - (long)start);
                    return this;
                }
                if (str instanceof String && Jvm.maxDirectMemory() > 0L) {
                    if (Jvm.isJava9Plus()) {
                        byte coder = StringUtils.getStringCoder((String)((String)str));
                        this.appendUtf8(StringUtils.extractBytes((String)((String)str)), start, end - start, coder);
                    } else {
                        this.appendUtf8(StringUtils.extractChars((String)((String)str)), start, end - start);
                    }
                    return this;
                }
            }
            AbstractBytes.ReportUnoptimised.reportOnce();
            super.append(str, start, end);
            return this;
        }
        catch (Exception e) {
            IndexOutOfBoundsException ioobe = new IndexOutOfBoundsException(e.toString());
            ioobe.initCause(e);
            throw ioobe;
        }
    }

    @Override
    @NotNull
    public VanillaBytes<U> appendUtf8(@NotNull CharSequence str) throws BufferOverflowException {
        ObjectUtils.requireNonNull((Object)str);
        AbstractBytes.ReportUnoptimised.reportOnce();
        try {
            if (this.isDirectMemory()) {
                if (str instanceof BytesStore) {
                    this.write((BytesStore)str, 0L, (long)str.length());
                    return this;
                }
                if (str instanceof String && Jvm.maxDirectMemory() > 0L) {
                    if (Jvm.isJava9Plus()) {
                        String str1 = (String)str;
                        byte coder = StringUtils.getStringCoder((String)str1);
                        this.appendUtf8(StringUtils.extractBytes((String)str1), 0, str.length(), coder);
                    } else {
                        this.appendUtf8(StringUtils.extractChars((String)((String)str)), 0, str.length());
                    }
                    return this;
                }
            }
            super.append(str, 0, str.length());
            return this;
        }
        catch (Exception e) {
            @NotNull BufferOverflowException e2 = new BufferOverflowException();
            e2.initCause(e);
            throw e2;
        }
    }

    @Override
    @NotNull
    public Bytes<U> append8bit(@NotNull CharSequence cs) throws BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException, ClosedIllegalStateException, ThreadingIllegalStateException {
        ObjectUtils.requireNonNull((Object)cs);
        if (this.isDirectMemory() && cs instanceof String && this.bytesStore instanceof NativeBytesStore) {
            return this.append8bitNBSS((String)cs);
        }
        return this.append8bit0(cs);
    }

    @Override
    @NotNull
    public Bytes<U> append8bit(@NotNull BytesStore<?, ?> bs) throws BufferOverflowException, BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        long remaining = bs.readLimit() - bs.readPosition();
        return this.write0(bs, 0L, remaining);
    }

    @Override
    @NotNull
    public Bytes<U> write(@NotNull BytesStore<?, ?> bytes, @NonNegative long offset, @NonNegative long length) throws BufferOverflowException, BufferUnderflowException, ClosedIllegalStateException, IllegalArgumentException, ThreadingIllegalStateException {
        ObjectUtils.requireNonNull(bytes);
        if ((offset | length) < 0L) {
            Longs.requireNonNegative((long)offset);
            Longs.requireNonNegative((long)length);
        }
        return this.write0(bytes, offset, length);
    }

    @NotNull
    private VanillaBytes<U> write0(@NotNull BytesStore<?, ?> bytes, @NonNegative long offset, long length) throws ClosedIllegalStateException, ThreadingIllegalStateException {
        this.ensureCapacity(this.writePosition() + length);
        if (length == (long)((int)length)) {
            if (bytes.canReadDirect(length) && this.canWriteDirect(length)) {
                long wAddr = this.addressForWritePosition();
                this.writeSkip(length);
                long rAddr = bytes.addressForRead(offset);
                UnsafeMemory.copyMemory((long)rAddr, (long)wAddr, (int)((int)length));
                return this;
            }
            this.bytesStore.write(this.writePosition(), bytes.bytesStore(), offset, length);
            this.uncheckedWritePosition(this.writePosition() + length);
            return this;
        }
        AbstractBytes.ReportUnoptimised.reportOnce();
        BytesInternal.writeFully(bytes, offset, length, this);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> append8bit(@NotNull String cs) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        ObjectUtils.requireNonNull((Object)cs);
        if (this.isDirectMemory()) {
            return this.append8bitNBSS(cs);
        }
        return this.append8bit0(cs);
    }

    @NotNull
    private Bytes<U> append8bitNBSS(@NotNull String s) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        int length = s.length();
        long offset = this.writeOffsetPositionMoved(length);
        NativeBytesStore bytesStore = (NativeBytesStore)this.bytesStore;
        long address = bytesStore.address + bytesStore.translate(offset);
        @Nullable Memory memory = bytesStore.memory;
        if (memory == null) {
            bytesStore.throwExceptionIfReleased();
            throw new NullPointerException("byteStore.memory is null.");
        }
        if (Jvm.isJava9Plus() && Jvm.maxDirectMemory() > 0L) {
            byte[] chars = StringUtils.extractBytes((String)s);
            for (int i = 0; i < length; ++i) {
                memory.writeByte(address + (long)i, chars[i]);
            }
        } else {
            int c0;
            int i;
            char[] chars = StringUtils.extractChars((String)s);
            for (i = 0; i < length - 3; i += 4) {
                c0 = chars[i] & 0xFF;
                int c1 = chars[i + 1] & 0xFF;
                int c2 = chars[i + 2] & 0xFF;
                int c3 = chars[i + 3] & 0xFF;
                memory.writeInt(address + (long)i, c0 | c1 << 8 | c2 << 16 | c3 << 24);
            }
            while (i < length) {
                c0 = chars[i];
                memory.writeByte(address + (long)i, (byte)c0);
                ++i;
            }
        }
        return this;
    }

    @Override
    @NotNull
    public String toString() {
        String string;
        this.reserve((ReferenceOwner)this);
        try {
            string = this.bytesStore instanceof NativeBytesStore ? this.toString2((NativeBytesStore)this.bytesStore) : this.toString0();
        }
        catch (IllegalStateException e) {
            try {
                try {
                    throw Jvm.rethrow((Throwable)e);
                }
                catch (Throwable throwable) {
                    this.release((ReferenceOwner)this);
                    throw throwable;
                }
            }
            catch (Exception e2) {
                return e2.toString();
            }
        }
        this.release((ReferenceOwner)this);
        return string;
    }

    private String toString2(@NotNull NativeBytesStore bytesStore) {
        @Nullable Memory memory = bytesStore.memory;
        int length = (int)Math.min(0x7FFFFFF0L, this.realReadRemaining());
        @NotNull char[] chars = new char[length];
        long address = bytesStore.address + bytesStore.translate(this.readPosition());
        for (int i = 0; i < length && (long)i < this.realCapacity(); ++i) {
            chars[i] = (char)(memory.readByte(address + (long)i) & 0xFF);
        }
        return StringUtils.newString((char[])chars);
    }

    @NotNull
    protected String toString0() throws ClosedIllegalStateException {
        int length = (int)Math.min(0x7FFFFFF0L, this.readRemaining());
        @NotNull char[] chars = new char[length];
        try {
            for (int i = 0; i < length; ++i) {
                chars[i] = (char)(this.bytesStore.readByte(this.readPosition() + (long)i) & 0xFF);
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            // empty catch block
        }
        return StringUtils.newString((char[])chars);
    }

    @NotNull
    protected Bytes<U> append8bit0(@NotNull CharSequence cs) throws BufferOverflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        int length = cs.length();
        long offset = this.writeOffsetPositionMoved(length);
        for (int i = 0; i < length; ++i) {
            int c = this.charAt(cs, i);
            if (c > 255) {
                c = 63;
            }
            this.bytesStore.writeByte(offset + (long)i, (byte)c);
        }
        return this;
    }

    @Override
    public boolean equalBytes(@NotNull BytesStore<?, ?> bytesStore, long length) throws BufferUnderflowException, ClosedIllegalStateException {
        ObjectUtils.requireNonNull(bytesStore);
        AbstractBytes.ReportUnoptimised.reportOnce();
        if (length < 0L) {
            throw new IllegalArgumentException();
        }
        if (this.isDirectMemory() && bytesStore instanceof VanillaBytes && bytesStore.isDirectMemory()) {
            long i;
            @NotNull VanillaBytes b2 = (VanillaBytes)Jvm.uncheckedCast(bytesStore);
            @NotNull NativeBytesStore nbs0 = (NativeBytesStore)this.bytesStore;
            @Nullable NativeBytesStore nbs2 = (NativeBytesStore)b2.bytesStore();
            for (i = 0L; i < length - 7L; i += 8L) {
                long l2;
                long addr0 = nbs0.address + this.readPosition() - nbs0.start() + i;
                long addr2 = nbs2.address + b2.readPosition() - nbs2.start() + i;
                long l0 = nbs0.memory.readLong(addr0);
                if (l0 == (l2 = nbs2.memory.readLong(addr2))) continue;
                return false;
            }
            while (i < length) {
                byte b1;
                long offset2 = this.readPosition() + i - nbs0.start();
                long offset21 = b2.readPosition() + i - nbs2.start();
                byte b0 = nbs0.memory.readByte(nbs0.address + offset2);
                if (b0 != (b1 = nbs2.memory.readByte(nbs2.address + offset21))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return super.equalBytes(bytesStore, length);
    }

    public void read8Bit(char[] chars, @NonNegative int length) throws BufferUnderflowException, ClosedIllegalStateException {
        AbstractBytes.ReportUnoptimised.reportOnce();
        if (this.isDirectMemory()) {
            long position = this.readPosition();
            @NotNull NativeBytesStore nbs = (NativeBytesStore)this.bytesStore();
            nbs.read8bit(position, chars, length);
        } else {
            long pos = this.readPosition();
            for (int i = 0; i < length; ++i) {
                chars[i] = (char)this.readUnsignedByte(pos + (long)i);
            }
        }
    }

    @Override
    public int byteCheckSum(@NonNegative int start, @NonNegative int end) throws IORuntimeException, BufferUnderflowException {
        int i;
        int b = 0;
        @Nullable NativeBytesStore bytesStore = (NativeBytesStore)this.bytesStore();
        @Nullable Memory memory = bytesStore.memory;
        assert (memory != null);
        long addr = bytesStore.addressForRead(start);
        int len = end - start;
        for (i = 0; i < len - 3; i += 4) {
            b = (byte)(b + (byte)(memory.readByte(addr + (long)i) + memory.readByte(addr + (long)i + 1L) + memory.readByte(addr + (long)i + 2L) + memory.readByte(addr + (long)i + 3L)));
        }
        while (i < len) {
            b = (byte)(b + memory.readByte(addr + (long)i));
            ++i;
        }
        return b & 0xFF;
    }

    @Override
    @NotNull
    public Bytes<U> appendUtf8(char[] chars, @NonNegative int offset, @NonNegative int length) throws BufferOverflowException, ClosedIllegalStateException, BufferUnderflowException, IllegalArgumentException, ThreadingIllegalStateException {
        long actualUTF8Length = AppendableUtil.findUtf8Length(chars, offset, length);
        this.ensureCapacity(this.writePosition() + actualUTF8Length);
        if (this.bytesStore instanceof NativeBytesStore) {
            @Nullable NativeBytesStore nbs = (NativeBytesStore)this.bytesStore;
            long position = nbs.appendUtf8(this.writePosition(), chars, offset, length);
            this.writePosition(position);
        } else {
            AbstractBytes.ReportUnoptimised.reportOnce();
            super.appendUtf8(chars, offset, length);
        }
        return this;
    }

    @Override
    public ByteBuffer toTemporaryDirectByteBuffer() throws IllegalArgumentException, ArithmeticException, ClosedIllegalStateException {
        this.throwExceptionIfReleased();
        if (this.isClear()) {
            return this.bytesStore.toTemporaryDirectByteBuffer();
        }
        return super.toTemporaryDirectByteBuffer();
    }

    @Override
    public int read(byte[] bytes) throws BufferUnderflowException, ClosedIllegalStateException, ThreadingIllegalStateException {
        ObjectUtils.requireNonNull((Object)bytes);
        AbstractBytes.ReportUnoptimised.reportOnce();
        int len = (int)Math.min((long)bytes.length, this.readRemaining());
        if (this.bytesStore instanceof NativeBytesStore) {
            @Nullable NativeBytesStore nbs = (NativeBytesStore)this.bytesStore;
            long len2 = nbs.read(this.readPosition(), bytes, 0, len);
            this.readSkip(len2);
            return (int)len2;
        }
        return super.read(bytes);
    }

    @Override
    public int compareTo(@NotNull CharSequence cs) {
        long len1 = this.readRemaining();
        int len2 = cs.length();
        long lim = Math.min(len1, (long)len2);
        int k = 0;
        while ((long)k < lim) {
            char c2;
            char c1 = this.charAt(this.bytesStore, k);
            if (c1 != (c2 = this.charAt(cs, k))) {
                return c1 - c2;
            }
            ++k;
        }
        return (int)(len1 - (long)len2);
    }
}

