/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Scanner;
import java.util.regex.Pattern;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.OffsetFormat;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.bytes.internal.NativeBytesStore;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.core.util.Ints;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ThrowingConsumer;
import net.openhft.chronicle.core.util.ThrowingConsumerNonCapturing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HexDumpBytes
implements Bytes<Void> {
    public static final long MASK = 0xFFFFFFFFL;
    private static final char[] HEXADECIMAL = "0123456789abcdef".toCharArray();
    private static final Pattern HEX_PATTERN = Pattern.compile("[0-9a-fA-F]{1,2}");
    private final NativeBytes<Void> base;
    private final Bytes<byte[]> text;
    private final Bytes<byte[]> comment = Bytes.allocateElasticOnHeap(64);
    private OffsetFormat offsetFormat = null;
    private long startOfLine = 0L;
    private int indent = 0;
    private int numberWrap = 16;

    public HexDumpBytes() {
        try {
            this.base = Bytes.allocateElasticDirect(256L);
            this.text = Bytes.allocateElasticOnHeap(1024);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    HexDumpBytes(@NotNull NativeBytes<Void> base, @NotNull BytesStore text) {
        try {
            long size = base.readRemaining();
            this.base = NativeBytes.wrapWithNativeBytes(NativeBytesStore.nativeStore(size), size);
            this.base.write(base);
            this.text = Bytes.allocateElasticOnHeap((int)text.readRemaining());
            this.text.write(text);
        }
        catch (IllegalArgumentException | IllegalStateException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static HexDumpBytes fromText(@NotNull Reader reader) throws NumberFormatException {
        HexDumpBytes tb = new HexDumpBytes();
        TextBytesReader reader2 = new TextBytesReader(reader, tb.text);
        try (Scanner sc = new Scanner(reader2);){
            while (sc.hasNext()) {
                if (sc.hasNext(HEX_PATTERN)) {
                    tb.base.rawWriteByte((byte)Integer.parseInt(sc.next(), 16));
                    continue;
                }
                sc.nextLine();
            }
        }
        catch (IllegalStateException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
        return tb;
    }

    public static HexDumpBytes fromText(@NotNull CharSequence text) throws NumberFormatException {
        return HexDumpBytes.fromText(new StringReader(text.toString()));
    }

    private static boolean startsWith(@NotNull CharSequence comment, char first) {
        return comment.length() > 0 && comment.charAt(0) == first;
    }

    public HexDumpBytes offsetFormat(OffsetFormat offsetFormat) {
        this.offsetFormat = offsetFormat;
        return this;
    }

    public int numberWrap() {
        return this.numberWrap;
    }

    public HexDumpBytes numberWrap(int numberWrap) {
        this.numberWrap = numberWrap;
        return this;
    }

    @Override
    public long readRemaining() {
        return this.base.readRemaining();
    }

    @Override
    public long writeRemaining() {
        return this.base.writeRemaining();
    }

    @Override
    public long readLimit() {
        return this.base.readLimit();
    }

    @Override
    public long writeLimit() {
        return this.base.writeLimit();
    }

    @Override
    @NotNull
    public String toHexString() {
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        try {
            if (this.lineLength() > 0L) {
                this.newLine();
            }
            return this.text.toString();
        }
        catch (Throwable e) {
            return e.toString();
        }
    }

    public int hashCode() {
        return this.base.hashCode();
    }

    public boolean equals(Object obj) {
        return this.base.equals(obj);
    }

    @Override
    @NotNull
    public String toString() {
        return this.base.toString();
    }

    @Override
    public boolean retainsComments() {
        return true;
    }

    @Override
    public Bytes<Void> comment(@NotNull CharSequence comment) throws IllegalStateException {
        if (this.comment.readRemaining() > 0L) {
            this.newLine();
        }
        if (HexDumpBytes.startsWith(comment, '#')) {
            this.indent = 0;
            ((Bytes)((Bytes)this.text.append('#')).append(comment)).append('\n');
            this.startOfLine = this.text.writePosition();
        } else {
            this.comment.clear().append(comment);
        }
        return this;
    }

    @Override
    public BytesOut<Void> indent(int n) throws IllegalStateException {
        this.indent += n;
        if (this.lineLength() > 0L) {
            this.newLine();
        }
        return this;
    }

    private long lineLength() {
        return this.text.writePosition() - this.startOfLine;
    }

    private void newLine() throws IllegalStateException {
        if (this.comment.readRemaining() > 0L) {
            while (this.lineLength() < (long)this.numberWrap * 3L - 3L) {
                this.text.append("   ");
            }
            while (this.lineLength() < (long)this.numberWrap * 3L) {
                this.text.append(' ');
            }
            this.text.append("# ");
            this.text.append(this.comment);
            this.comment.clear();
        }
        this.text.append('\n');
        this.startOfLine = this.text.writePosition();
    }

    private void appendOffset(@NonNegative long offset) throws IllegalStateException, BufferUnderflowException {
        if (this.offsetFormat == null) {
            return;
        }
        this.offsetFormat.append(offset, this.text);
        long wp = this.text.writePosition();
        if (this.text.peekUnsignedByte(wp - 1L) > 32) {
            this.text.append(' ');
        }
        this.startOfLine = this.text.writePosition();
    }

    @Override
    public BytesStore copy() {
        ReferenceCountedUtil.throwExceptionIfReleased(this);
        return new HexDumpBytes(this.base, this.text);
    }

    @Override
    public boolean isElastic() {
        return this.base.isElastic();
    }

    @Override
    public void ensureCapacity(@NonNegative long desiredCapacity) throws IllegalArgumentException, IllegalStateException {
        this.base.ensureCapacity(desiredCapacity);
    }

    @Override
    @NotNull
    public BytesStore bytesStore() {
        return this.base;
    }

    @Override
    @NotNull
    public Bytes<Void> compact() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> clear() throws IllegalStateException {
        this.base.clear();
        this.text.clear();
        this.comment.clear();
        this.startOfLine = 0L;
        return this;
    }

    @Override
    public boolean isDirectMemory() {
        return false;
    }

    @Override
    @NonNegative
    public long capacity() {
        return this.base.capacity();
    }

    @Override
    public long addressForRead(@NonNegative long offset) throws UnsupportedOperationException, IllegalStateException, BufferUnderflowException {
        Longs.requireNonNegative((long)offset);
        return this.base.addressForRead(offset);
    }

    @Override
    public long addressForWrite(@NonNegative long offset) throws UnsupportedOperationException {
        Longs.requireNonNegative((long)offset);
        throw new UnsupportedOperationException();
    }

    @Override
    public long addressForWritePosition() throws UnsupportedOperationException, BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean compareAndSwapInt(@NonNegative long offset, int expected, int value) throws BufferOverflowException, IllegalStateException {
        if (this.base.compareAndSwapInt(offset & 0xFFFFFFFFL, expected, value)) {
            this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 4);
            return true;
        }
        return false;
    }

    @Override
    public void testAndSetInt(@NonNegative long offset, int expected, int value) throws IllegalStateException, BufferOverflowException {
        long off = offset & 0xFFFFFFFFL;
        this.base.testAndSetInt(off, expected, value);
        this.copyToText(off, offset >>> 32, 4);
    }

    @Override
    public boolean compareAndSwapLong(@NonNegative long offset, long expected, long value) throws BufferOverflowException, IllegalStateException {
        if (this.base.compareAndSwapLong(offset & 0xFFFFFFFFL, expected, value)) {
            this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 8);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Void underlyingObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void move(@NonNegative long from, @NonNegative long to, @NonNegative long length) {
        throw new UnsupportedOperationException();
    }

    public void reserve(ReferenceOwner owner) throws IllegalStateException {
        this.base.reserve(owner);
    }

    public void release(ReferenceOwner owner) throws IllegalStateException {
        this.base.release(owner);
        if (this.base.refCount() == 0) {
            this.text.releaseLast();
            this.comment.releaseLast();
        }
    }

    public void releaseLast(ReferenceOwner owner) throws IllegalStateException {
        this.base.releaseLast(owner);
        if (this.base.refCount() == 0) {
            this.text.releaseLast();
            this.comment.releaseLast();
        }
    }

    public int refCount() {
        return this.base.refCount();
    }

    public boolean tryReserve(ReferenceOwner owner) throws IllegalStateException, IllegalArgumentException {
        return this.base.tryReserve(owner);
    }

    public boolean reservedBy(ReferenceOwner owner) throws IllegalStateException {
        return this.base.reservedBy(owner);
    }

    @Override
    @NotNull
    public Bytes<Void> writeByte(@NonNegative long offset, byte i8) throws BufferOverflowException, IllegalStateException {
        this.base.writeByte(offset & 0xFFFFFFFFL, i8);
        this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 1);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeShort(@NonNegative long offset, short i) throws BufferOverflowException, IllegalStateException {
        this.base.writeShort(offset & 0xFFFFFFFFL, i);
        this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 2);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeInt24(@NonNegative long offset, int i) throws BufferOverflowException, IllegalStateException {
        this.base.writeInt24(offset & 0xFFFFFFFFL, i);
        this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 3);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeInt(@NonNegative long offset, int i) throws BufferOverflowException, IllegalStateException {
        return this.writeOrderedInt(offset, i);
    }

    @Override
    @NotNull
    public Bytes<Void> writeOrderedInt(@NonNegative long offset, int i) throws BufferOverflowException, IllegalStateException {
        this.base.writeOrderedInt(offset & 0xFFFFFFFFL, i);
        this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 4);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeLong(@NonNegative long offset, long i) throws BufferOverflowException, IllegalStateException {
        return this.writeOrderedLong(offset, i);
    }

    @Override
    @NotNull
    public Bytes<Void> writeOrderedLong(@NonNegative long offset, long i) throws BufferOverflowException, IllegalStateException {
        this.base.writeOrderedLong(offset & 0xFFFFFFFFL, i);
        this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeFloat(@NonNegative long offset, float d) throws BufferOverflowException, IllegalStateException {
        this.base.writeFloat(offset & 0xFFFFFFFFL, d);
        this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 4);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeDouble(@NonNegative long offset, double d) throws BufferOverflowException, IllegalStateException {
        this.base.writeDouble(offset & 0xFFFFFFFFL, d);
        this.copyToText(offset & 0xFFFFFFFFL, offset >>> 32, 8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeVolatileByte(@NonNegative long offset, byte i8) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> writeVolatileShort(@NonNegative long offset, short i16) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> writeVolatileInt(@NonNegative long offset, int i32) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> writeVolatileLong(@NonNegative long offset, long i64) throws BufferOverflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> write(@NonNegative long offsetInRDO, byte[] byteArray, @NonNegative int offset, @NonNegative int length) {
        Longs.requireNonNegative((long)offsetInRDO);
        ObjectUtils.requireNonNull((Object)byteArray);
        Ints.requireNonNegative((int)offset);
        Ints.requireNonNegative((int)length);
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(@NonNegative long offsetInRDO, @NotNull ByteBuffer bytes, @NonNegative int offset, @NonNegative int length) {
        ObjectUtils.requireNonNull((Object)bytes);
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> write(@NonNegative long writeOffset, @NotNull RandomDataInput bytes, @NonNegative long readOffset, @NonNegative long length) {
        Longs.requireNonNegative((long)writeOffset);
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        Longs.requireNonNegative((long)readOffset);
        Longs.requireNonNegative((long)length);
        throw new UnsupportedOperationException();
    }

    @Override
    public long write8bit(@NonNegative long position, @NotNull BytesStore bs) {
        ObjectUtils.requireNonNull((Object)bs);
        throw new UnsupportedOperationException();
    }

    @Override
    public long write8bit(@NonNegative long position, @NotNull String s, @NonNegative int start, @NonNegative int length) {
        ObjectUtils.requireNonNull((Object)s);
        throw new UnsupportedOperationException();
    }

    @Override
    public void nativeWrite(long address, @NonNegative long position, @NonNegative long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> zeroOut(@NonNegative long start, @NonNegative long end) throws IllegalStateException {
        return (Bytes)this.base.zeroOut(start & 0xFFFFFFFFL, end & 0xFFFFFFFFL);
    }

    @Override
    @NotNull
    public Bytes<Void> readPosition(@NonNegative long position) throws BufferUnderflowException, IllegalStateException {
        this.base.readPosition(position & 0xFFFFFFFFL);
        this.text.readPosition(position >>> 32);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> readLimit(@NonNegative long limit) throws BufferUnderflowException {
        this.base.readLimit(limit & 0xFFFFFFFFL);
        this.text.readPosition(limit >>> 32);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> readSkip(long bytesToSkip) throws BufferUnderflowException, IllegalStateException {
        this.base.readSkip(bytesToSkip);
        return this;
    }

    @Override
    public void uncheckedReadSkipOne() {
        this.base.uncheckedReadSkipOne();
    }

    @Override
    public void uncheckedReadSkipBackOne() {
        this.base.uncheckedReadSkipBackOne();
    }

    @Override
    public long readStopBit() throws IORuntimeException, IllegalStateException, BufferUnderflowException {
        return this.base.readStopBit();
    }

    @Override
    public char readStopBitChar() throws IORuntimeException, IllegalStateException, BufferUnderflowException {
        return this.base.readStopBitChar();
    }

    @Override
    public double readStopBitDouble() throws IllegalStateException {
        return this.base.readStopBitDouble();
    }

    @Override
    public double readStopBitDecimal() throws IllegalStateException, BufferUnderflowException {
        return this.base.readStopBitDecimal();
    }

    @Override
    public byte readByte() throws IllegalStateException {
        return this.base.readByte();
    }

    @Override
    public int readUnsignedByte() throws IllegalStateException {
        return this.base.readUnsignedByte();
    }

    @Override
    public int uncheckedReadUnsignedByte() {
        return this.base.uncheckedReadUnsignedByte();
    }

    @Override
    public short readShort() throws BufferUnderflowException, IllegalStateException {
        return this.base.readShort();
    }

    @Override
    public int readInt() throws BufferUnderflowException, IllegalStateException {
        return this.base.readInt();
    }

    @Override
    public long readLong() throws BufferUnderflowException, IllegalStateException {
        return this.base.readLong();
    }

    @Override
    public float readFloat() throws BufferUnderflowException, IllegalStateException {
        return this.base.readFloat();
    }

    @Override
    public double readDouble() throws BufferUnderflowException, IllegalStateException {
        return this.base.readDouble();
    }

    @Override
    public int readVolatileInt() throws BufferUnderflowException, IllegalStateException {
        return this.base.readVolatileInt();
    }

    @Override
    public long readVolatileLong() throws BufferUnderflowException, IllegalStateException {
        return this.base.readVolatileLong();
    }

    @Override
    public int peekUnsignedByte() throws IllegalStateException {
        return this.base.peekUnsignedByte();
    }

    @Override
    public int lastDecimalPlaces() {
        return this.base.lastDecimalPlaces();
    }

    @Override
    public void lastDecimalPlaces(int lastDecimalPlaces) {
        this.base.lastDecimalPlaces(lastDecimalPlaces);
    }

    @Override
    public boolean lastNumberHadDigits() {
        return this.base.lastNumberHadDigits();
    }

    @Override
    public void lastNumberHadDigits(boolean lastNumberHadDigits) {
        this.base.lastNumberHadDigits(lastNumberHadDigits);
    }

    @Override
    @NotNull
    public BigDecimal readBigDecimal() throws BufferUnderflowException, ArithmeticException, IllegalStateException {
        return this.base.readBigDecimal();
    }

    @Override
    @NotNull
    public BigInteger readBigInteger() throws BufferUnderflowException, ArithmeticException, IllegalStateException {
        return this.base.readBigInteger();
    }

    @Override
    public void readWithLength(@NonNegative long length, @NotNull BytesOut<Void> bytesOut) throws BufferUnderflowException, IORuntimeException, IllegalStateException, BufferOverflowException {
        this.base.readWithLength(length, bytesOut);
    }

    @Override
    public <T extends ReadBytesMarshallable> T readMarshallableLength16(@NotNull Class<T> clazz, @Nullable T using) throws BufferUnderflowException, IllegalStateException {
        return (T)this.base.readMarshallableLength16(clazz, using);
    }

    @Override
    @NotNull
    public Bytes<Void> readPositionUnlimited(@NonNegative long position) throws BufferUnderflowException, IllegalStateException {
        return (Bytes)this.base.readPositionUnlimited(position);
    }

    @Override
    @NotNull
    public Bytes<Void> readPositionRemaining(@NonNegative long position, @NonNegative long remaining) throws BufferUnderflowException, IllegalStateException {
        return (Bytes)this.base.readPositionRemaining(position, remaining);
    }

    @Override
    public void readWithLength0(@NonNegative long length, @NotNull ThrowingConsumerNonCapturing<Bytes<Void>, IORuntimeException, BytesOut> bytesConsumer, StringBuilder sb, BytesOut<?> toBytes) throws BufferUnderflowException, IORuntimeException, IllegalStateException {
        this.base.readWithLength0(length, bytesConsumer, sb, toBytes);
    }

    @Override
    public void readWithLength(@NonNegative long length, @NotNull ThrowingConsumer<Bytes<Void>, IORuntimeException> bytesConsumer) throws BufferUnderflowException, IORuntimeException, IllegalStateException {
        this.base.readWithLength(length, bytesConsumer);
    }

    @Override
    public boolean readBoolean() throws IllegalStateException {
        return this.base.readBoolean();
    }

    @Override
    public int readUnsignedShort() throws BufferUnderflowException, IllegalStateException {
        return this.base.readUnsignedShort();
    }

    @Override
    public int readInt24() throws BufferUnderflowException, IllegalStateException {
        return this.base.readInt24();
    }

    @Override
    public int readUnsignedInt24() throws BufferUnderflowException, IllegalStateException {
        return this.base.readUnsignedInt24();
    }

    @Override
    public long readUnsignedInt() throws BufferUnderflowException, IllegalStateException {
        return this.base.readUnsignedInt();
    }

    @Override
    @Nullable
    public String readUtf8() throws BufferUnderflowException, IORuntimeException, IllegalStateException, ArithmeticException {
        return this.base.readUtf8();
    }

    @Override
    @Nullable
    public String read8bit() throws IORuntimeException, BufferUnderflowException, IllegalStateException, ArithmeticException {
        return this.base.read8bit();
    }

    @Override
    public <C extends Appendable & CharSequence> boolean readUtf8(@NotNull C sb) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException, IllegalStateException, ArithmeticException {
        return this.base.readUtf8(sb);
    }

    public <C extends Appendable & CharSequence> long readUtf8(@NonNegative long offset, @NotNull C sb) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException, ArithmeticException, IllegalStateException {
        return this.base.readUtf8(offset, sb);
    }

    public <C extends Appendable & CharSequence> long readUtf8Limited(@NonNegative long offset, @NotNull C sb, @NonNegative int maxUtf8Len) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException, IllegalStateException {
        return this.base.readUtf8Limited(offset, sb, maxUtf8Len);
    }

    @Override
    @Nullable
    public String readUtf8Limited(@NonNegative long offset, @NonNegative int maxUtf8Len) throws BufferUnderflowException, IORuntimeException, IllegalArgumentException, IllegalStateException {
        return this.base.readUtf8Limited(offset, maxUtf8Len);
    }

    public <C extends Appendable & CharSequence> boolean readUTF\u0394(@NotNull C sb) throws IORuntimeException, IllegalArgumentException, BufferUnderflowException, IllegalStateException, ArithmeticException {
        return this.base.readUtf8(sb);
    }

    @Override
    public boolean read8bit(@NotNull Bytes<?> b) throws BufferUnderflowException, IllegalStateException, BufferOverflowException, ArithmeticException {
        return this.base.read8bit(b);
    }

    @Override
    public boolean read8bit(@NotNull StringBuilder sb) throws IORuntimeException, BufferUnderflowException, ArithmeticException, IllegalStateException {
        return this.base.read8bit(sb);
    }

    @Override
    public int read(byte[] bytes) throws IllegalStateException, BufferUnderflowException {
        return this.base.read(bytes);
    }

    @Override
    public int read(byte[] bytes, @NonNegative int off, @NonNegative int len) throws IllegalStateException, BufferUnderflowException {
        return this.base.read(bytes, off, len);
    }

    @Override
    public int read(char[] bytes, int off, @NonNegative int len) throws IllegalStateException {
        return this.base.read(bytes, off, len);
    }

    @Override
    public void read(@NotNull ByteBuffer buffer) throws IllegalStateException {
        this.base.read(buffer);
    }

    @Override
    public void read(@NotNull Bytes<?> bytes, @NonNegative int length) throws BufferUnderflowException, IllegalStateException, BufferOverflowException {
        this.base.read(bytes, length);
    }

    @Override
    @NotNull
    public <E extends Enum<E>> E readEnum(@NotNull Class<E> eClass) throws IORuntimeException, BufferUnderflowException, IllegalStateException, ArithmeticException, BufferOverflowException {
        return (E)this.base.readEnum(eClass);
    }

    @Override
    public void readHistogram(@NotNull Histogram histogram) throws BufferUnderflowException, IllegalStateException, ArithmeticException {
        this.base.readHistogram(histogram);
    }

    @Override
    public void readWithLength(@NotNull Bytes<?> bytes) throws ArithmeticException, BufferOverflowException, IllegalStateException, BufferUnderflowException {
        this.base.readWithLength(bytes);
    }

    @Override
    @NotNull
    public Bytes<Void> writePosition(@NonNegative long position) throws BufferOverflowException {
        Longs.requireNonNegative((long)position);
        this.base.writePosition(position & 0xFFFFFFFFL);
        this.text.writePosition(position >>> 32);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeLimit(@NonNegative long limit) throws BufferOverflowException {
        this.base.writeLimit(limit);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeSkip(long bytesToSkip) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeSkip(bytesToSkip);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeByte(byte i8) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeByte(i8);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    @Override
    @NonNegative
    public long writePosition() {
        return this.base.writePosition() | this.text.writePosition() << 32;
    }

    @Override
    public long lengthWritten(long startPosition) {
        return this.base.writePosition() - (startPosition & 0xFFFFFFFFL);
    }

    private void copyToText(long pos) throws IllegalStateException {
        try {
            if (this.lineLength() == 0L && this.offsetFormat != null) {
                this.appendOffset(pos);
                this.startOfLine = this.text.writePosition();
            }
            this.copyToText0(pos);
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void copyToText0(long pos) {
        long end = this.base.writePosition();
        if (pos < end) {
            this.doIndent();
            do {
                int value = this.base.readUnsignedByte(pos);
                long ll = this.lineLength();
                if (ll >= (long)this.numberWrap * 3L - 1L) {
                    this.newLine();
                    this.appendOffset(pos);
                    this.doIndent();
                    this.startOfLine = this.text.writePosition();
                }
                ++pos;
                long wp = this.text.writePosition();
                if (this.text.peekUnsignedByte(wp - 1L) > 32) {
                    this.text.append(' ');
                }
                this.appendBase16(value);
            } while (pos < end);
        }
    }

    private void appendBase16(int value) {
        try {
            this.text.appendBase16(value, 2);
        }
        catch (IllegalArgumentException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void copyToText(long pos, long tpos, int length) throws IllegalStateException {
        try {
            if (tpos > 0L && this.text.readUnsignedByte(tpos) <= 32) {
                ++tpos;
            }
            while (length-- > 0) {
                int value = this.base.readUnsignedByte(pos++);
                this.text.writeUnsignedByte(tpos++, HEXADECIMAL[value >> 4]);
                this.text.writeUnsignedByte(tpos++, HEXADECIMAL[value & 0xF]);
                if (length <= 0) continue;
                this.text.writeUnsignedByte(tpos++, 32);
            }
        }
        catch (ArithmeticException | IllegalArgumentException | BufferOverflowException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void doIndent() {
        if (this.lineLength() == 0L && this.indent > 0) {
            for (int i = 0; i < this.indent; ++i) {
                this.text.append("   ");
            }
            this.startOfLine = this.text.writePosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeShort(short i16) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeShort(i16);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeInt(int i) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeInt(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeIntAdv(int i, @NonNegative int advance) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeIntAdv(i, advance);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeLong(long i64) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeLong(i64);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeLongAdv(long i64, @NonNegative int advance) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeLongAdv(i64, advance);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeFloat(float f) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeFloat(f);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeDouble(double d) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeDouble(d);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeDoubleAndInt(double d, int i) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeDouble(d);
            this.base.writeInt(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write(byte[] byteArray, int offset, int length) throws BufferOverflowException, IllegalArgumentException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.write(byteArray, offset, length);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeSome(@NotNull ByteBuffer buffer) throws BufferOverflowException, IllegalStateException, BufferUnderflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeSome(buffer);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeOrderedInt(int i) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeOrderedInt(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeOrderedLong(long i) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeOrderedLong(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> clearAndPad(@NonNegative long length) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.clearAndPad(length);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    @Override
    @NotNull
    public Bytes<Void> prewrite(byte[] bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> prewrite(BytesStore bytes) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> prewriteByte(byte b) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> prewriteShort(short i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> prewriteInt(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> prewriteLong(long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte readByte(@NonNegative long offset) throws BufferUnderflowException, IllegalStateException {
        return this.base.readByte(offset);
    }

    @Override
    public int peekUnsignedByte(@NonNegative long offset) throws IllegalStateException, BufferUnderflowException {
        return this.base.peekUnsignedByte(offset);
    }

    @Override
    public short readShort(@NonNegative long offset) throws BufferUnderflowException, IllegalStateException {
        return this.base.readShort(offset);
    }

    @Override
    public int readInt(@NonNegative long offset) throws BufferUnderflowException, IllegalStateException {
        return this.base.readInt(offset);
    }

    @Override
    public long readLong(@NonNegative long offset) throws BufferUnderflowException, IllegalStateException {
        return this.base.readLong(offset);
    }

    @Override
    public float readFloat(@NonNegative long offset) throws BufferUnderflowException, IllegalStateException {
        return this.base.readFloat(offset);
    }

    @Override
    public double readDouble(@NonNegative long offset) throws BufferUnderflowException, IllegalStateException {
        return this.base.readDouble(offset);
    }

    @Override
    public byte readVolatileByte(@NonNegative long offset) throws BufferUnderflowException, IllegalStateException {
        return this.base.readVolatileByte(offset);
    }

    @Override
    public short readVolatileShort(@NonNegative long offset) throws BufferUnderflowException, IllegalStateException {
        return this.base.readVolatileShort(offset);
    }

    @Override
    public int readVolatileInt(@NonNegative long offset) throws BufferUnderflowException, IllegalStateException {
        return this.base.readVolatileInt(offset);
    }

    @Override
    public long readVolatileLong(@NonNegative long offset) throws BufferUnderflowException, IllegalStateException {
        return this.base.readVolatileLong(offset);
    }

    @Override
    public void nativeRead(@NonNegative long position, long address, @NonNegative long size) throws BufferUnderflowException, IllegalStateException {
        this.base.nativeRead(position, address, size);
    }

    @Override
    @NonNegative
    public long readPosition() {
        return this.base.readPosition() | this.text.readPosition() << 32;
    }

    @Override
    public void lenient(boolean lenient) {
        this.base.lenient(lenient);
    }

    @Override
    public boolean lenient() {
        return this.base.lenient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMarshallableLength16(@NotNull WriteBytesMarshallable marshallable) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeMarshallableLength16(marshallable);
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bytes<?> write(@NotNull InputStream inputStream) throws IOException, IllegalStateException, BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.write(inputStream);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeStopBit(long x) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeStopBit(x);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeStopBit(char x) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeStopBit(x);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeStopBit(double d) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeStopBit(d);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeStopBitDecimal(double d) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeStopBitDecimal(d);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    @Override
    @NotNull
    public Bytes<Void> writeUtf8(@Nullable CharSequence text) throws BufferOverflowException, IllegalStateException, IllegalArgumentException {
        long pos = this.base.writePosition();
        try {
            this.base.writeUtf8(text);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            this.copyToText(pos);
        }
    }

    @Override
    @NotNull
    public Bytes<Void> writeUtf8(@Nullable String text) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeUtf8(text);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        catch (IllegalArgumentException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write8bit(@Nullable CharSequence text) throws BufferOverflowException, IllegalStateException, BufferUnderflowException, ArithmeticException {
        long pos = this.base.writePosition();
        try {
            this.base.write8bit(text);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write8bit(@NotNull CharSequence text, @NonNegative int start, @NonNegative int length) throws BufferOverflowException, IndexOutOfBoundsException, IllegalStateException, BufferUnderflowException, ArithmeticException {
        long pos = this.base.writePosition();
        try {
            this.base.write8bit(text, start, length);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write8bit(@NotNull String text, @NonNegative int start, @NonNegative int length) throws BufferOverflowException, IndexOutOfBoundsException, IllegalStateException, BufferUnderflowException, ArithmeticException {
        long pos = this.base.writePosition();
        try {
            this.base.write8bit(text, start, length);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write(@NotNull CharSequence text) throws BufferOverflowException, IllegalStateException, IndexOutOfBoundsException {
        long pos = this.base.writePosition();
        try {
            this.base.write(text);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write(@NotNull CharSequence text, @NonNegative int startText, @NonNegative int length) throws BufferOverflowException, IndexOutOfBoundsException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.write(text, startText, length);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write8bit(@Nullable String s) throws BufferOverflowException, IllegalStateException, ArithmeticException {
        long pos = this.base.writePosition();
        try {
            this.base.write8bit(s);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Bytes<Void> write8bit(@Nullable BytesStore bs) throws BufferOverflowException, IllegalStateException, BufferUnderflowException {
        long pos = this.base.writePosition();
        try {
            if (bs == null) {
                this.base.writeStopBit(-1L);
            } else {
                long offset = bs.readPosition();
                long readRemaining = Math.min(this.base.writeRemaining(), bs.readLimit() - offset);
                this.base.writeStopBit(readRemaining);
                try {
                    this.base.write(bs, offset, readRemaining);
                }
                catch (IllegalArgumentException | BufferUnderflowException e) {
                    throw new AssertionError((Object)e);
                }
            }
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeUnsignedByte(int i) throws BufferOverflowException, IllegalStateException, ArithmeticException {
        long pos = this.base.writePosition();
        try {
            this.base.writeUnsignedByte(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeUnsignedShort(int u16) throws BufferOverflowException, IllegalStateException, ArithmeticException {
        long pos = this.base.writePosition();
        try {
            this.base.writeUnsignedShort(u16);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeInt24(int i) throws BufferOverflowException, IllegalStateException, ArithmeticException {
        long pos = this.base.writePosition();
        try {
            this.base.writeInt24(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeUnsignedInt24(int i) throws BufferOverflowException, IllegalStateException, ArithmeticException {
        long pos = this.base.writePosition();
        try {
            this.base.writeUnsignedInt24(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeUnsignedInt(long i) throws BufferOverflowException, ArithmeticException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeUnsignedInt(i);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write(@NotNull RandomDataInput bytes) throws IllegalStateException, BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.write(bytes);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bytes<Void> write(@NotNull BytesStore<?, ?> bytes) throws IllegalStateException, BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.write(bytes);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeSome(@NotNull Bytes<?> bytes) throws IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeSome((Bytes)bytes);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write(@NotNull RandomDataInput bytes, @NonNegative long offset, @NonNegative long length) throws BufferOverflowException, BufferUnderflowException, IllegalStateException, IllegalArgumentException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        Longs.requireNonNegative((long)offset);
        Longs.requireNonNegative((long)length);
        long pos = this.base.writePosition();
        try {
            this.base.write(bytes, offset, length);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write(@NotNull BytesStore bytes, @NonNegative long offset, @NonNegative long length) throws BufferOverflowException, BufferUnderflowException, IllegalStateException, IllegalArgumentException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        Longs.requireNonNegative((long)offset);
        Longs.requireNonNegative((long)length);
        long pos = this.base.writePosition();
        try {
            this.base.write(bytes, offset, length);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> write(byte[] byteArray) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.write(byteArray);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bytes<Void> writeBoolean(boolean flag) throws BufferOverflowException, IllegalStateException {
        long pos = this.base.writePosition();
        try {
            this.base.writeBoolean(flag);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Enum<E>> Bytes<Void> writeEnum(@NotNull E e) throws BufferOverflowException, IllegalStateException, ArithmeticException {
        long pos = this.base.writePosition();
        try {
            this.base.writeEnum(e);
            HexDumpBytes hexDumpBytes = this;
            return hexDumpBytes;
        }
        finally {
            this.copyToText(pos);
        }
    }

    @Override
    public void writePositionRemaining(@NonNegative long position, @NonNegative long length) throws BufferOverflowException {
        Longs.requireNonNegative((long)position);
        Longs.requireNonNegative((long)length);
        this.writePosition(position);
        this.writeLimit(this.base.writePosition() + length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeHistogram(@NotNull Histogram histogram) throws IllegalStateException, BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeHistogram(histogram);
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBigDecimal(@NotNull BigDecimal bd) throws IllegalArgumentException, IllegalStateException, BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeBigDecimal(bd);
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBigInteger(@NotNull BigInteger bi) throws IllegalArgumentException, IllegalStateException, BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeBigInteger(bi);
        }
        finally {
            this.copyToText(pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeWithLength(@NotNull RandomDataInput bytes) throws IllegalStateException, BufferOverflowException {
        long pos = this.base.writePosition();
        try {
            this.base.writeWithLength(bytes);
        }
        finally {
            this.copyToText(pos);
        }
    }

    private static class TextBytesReader
    extends Reader {
        private final Reader reader;
        private final Bytes<?> base;

        public TextBytesReader(Reader reader, Bytes<?> base) {
            this.reader = reader;
            this.base = base;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int len2 = this.reader.read(cbuf, off, len);
            this.base.append(new String(cbuf, off, len));
            return len2;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

