/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.algo.BytesStoreHash;
import net.openhft.chronicle.bytes.internal.EmptyByteStore;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.util.Ints;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public final class SingletonEmptyByteStore
implements EmptyByteStore {
    private static final String OP_WITH_NO_CONTENT = "This operation is not supported for an EmptyByteStore with no content.";
    public static final EmptyByteStore INSTANCE = new SingletonEmptyByteStore();
    private static final int HASH_CODE_VALUE = BytesStoreHash.hash32(INSTANCE);

    private SingletonEmptyByteStore() {
    }

    public void reserve(ReferenceOwner owner) throws IllegalStateException {
    }

    public void release(ReferenceOwner owner) throws IllegalStateException {
    }

    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
    }

    public int refCount() {
        return 1;
    }

    public boolean tryReserve(ReferenceOwner owner) {
        return false;
    }

    public boolean reservedBy(ReferenceOwner owner) {
        return true;
    }

    @Override
    @NotNull
    public EmptyByteStore writeByte(@NonNegative long offset, byte i8) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    @NotNull
    public EmptyByteStore writeShort(@NonNegative long offset, short i) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    @NotNull
    public EmptyByteStore writeInt(@NonNegative long offset, int i) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    @NotNull
    public EmptyByteStore writeOrderedInt(@NonNegative long offset, int i) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    @NotNull
    public EmptyByteStore writeLong(@NonNegative long offset, long i) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    @NotNull
    public EmptyByteStore writeOrderedLong(@NonNegative long offset, long i) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    @NotNull
    public EmptyByteStore writeFloat(@NonNegative long offset, float d) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    @NotNull
    public EmptyByteStore writeDouble(@NonNegative long offset, double d) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    @NotNull
    public EmptyByteStore writeVolatileByte(@NonNegative long offset, byte i8) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    @NotNull
    public EmptyByteStore writeVolatileShort(@NonNegative long offset, short i16) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    @NotNull
    public EmptyByteStore writeVolatileInt(@NonNegative long offset, int i32) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    @NotNull
    public EmptyByteStore writeVolatileLong(@NonNegative long offset, long i64) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    @NotNull
    public EmptyByteStore write(@NonNegative long offsetInRDO, byte[] byteArray, @NonNegative int offset, @NonNegative int length) {
        Longs.requireNonNegative((long)offsetInRDO);
        ObjectUtils.requireNonNull((Object)byteArray);
        Ints.requireNonNegative((int)offset);
        Ints.requireNonNegative((int)length);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public void write(@NonNegative long offsetInRDO, @NotNull ByteBuffer bytes, @NonNegative int offset, @NonNegative int length) {
        Longs.requireNonNegative((long)offsetInRDO);
        ObjectUtils.requireNonNull((Object)bytes);
        Ints.requireNonNegative((int)offset);
        Ints.requireNonNegative((int)length);
        throw this.newUnsupportedOperationException();
    }

    @Override
    @NotNull
    public EmptyByteStore write(@NonNegative long writeOffset, @NotNull RandomDataInput bytes, @NonNegative long readOffset, @NonNegative long length) {
        Longs.requireNonNegative((long)writeOffset);
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        Longs.requireNonNegative((long)readOffset);
        Longs.requireNonNegative((long)length);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public byte readByte(@NonNegative long offset) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public int peekUnsignedByte(@NonNegative long offset) {
        Longs.requireNonNegative((long)offset);
        return -1;
    }

    @Override
    public short readShort(@NonNegative long offset) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public int readInt(@NonNegative long offset) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public long readLong(@NonNegative long offset) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public float readFloat(@NonNegative long offset) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public double readDouble(@NonNegative long offset) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public byte readVolatileByte(@NonNegative long offset) throws BufferUnderflowException {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public short readVolatileShort(@NonNegative long offset) throws BufferUnderflowException {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public int readVolatileInt(@NonNegative long offset) throws BufferUnderflowException {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public long readVolatileLong(@NonNegative long offset) throws BufferUnderflowException {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public boolean isDirectMemory() {
        return false;
    }

    @NotNull
    public EmptyByteStore copy() {
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> bytesForRead() throws IllegalStateException {
        return VanillaBytes.vanillaBytes();
    }

    @Override
    @NonNegative
    public long capacity() {
        return 0L;
    }

    @Override
    public Void underlyingObject() {
        return null;
    }

    @Override
    public boolean inside(@NonNegative long offset) {
        Longs.requireNonNegative((long)offset);
        return false;
    }

    @Override
    public boolean inside(@NonNegative long offset, @NonNegative long buffer) {
        Longs.requireNonNegative((long)offset);
        Longs.requireNonNegative((long)buffer);
        return false;
    }

    @Override
    public long copyTo(@NotNull BytesStore store) {
        ObjectUtils.requireNonNull((Object)store);
        return 0L;
    }

    @Override
    public void nativeWrite(long address, @NonNegative long position, @NonNegative long size) {
        Longs.requireNonNegative((long)position);
        Longs.requireNonNegative((long)size);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public long write8bit(@NonNegative long position, @NotNull BytesStore bs) {
        Longs.requireNonNegative((long)position);
        ObjectUtils.requireNonNull((Object)bs);
        throw new BufferOverflowException();
    }

    @Override
    public long write8bit(@NonNegative long position, @NotNull String s, @NonNegative int start, @NonNegative int length) {
        Longs.requireNonNegative((long)position);
        ObjectUtils.requireNonNull((Object)s);
        Ints.requireNonNegative((int)start);
        Ints.requireNonNegative((int)length);
        throw new BufferOverflowException();
    }

    @Override
    public void nativeRead(@NonNegative long position, long address, @NonNegative long size) {
        Longs.requireNonNegative((long)position);
        Longs.requireNonNegative((long)size);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public boolean compareAndSwapInt(@NonNegative long offset, int expected, int value) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public void testAndSetInt(@NonNegative long offset, int expected, int value) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public boolean compareAndSwapLong(@NonNegative long offset, long expected, long value) {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public boolean equalBytes(@NotNull BytesStore bytesStore, long length) {
        ObjectUtils.requireNonNull((Object)bytesStore);
        Longs.requireNonNegative((long)length);
        return length == 0L || bytesStore.length() == 0;
    }

    @Override
    public void move(@NonNegative long from, @NonNegative long to, @NonNegative long length) {
        Longs.requireNonNegative((long)from);
        Longs.requireNonNegative((long)to);
        Longs.requireNonNegative((long)length);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public long addressForRead(@NonNegative long offset) throws BufferUnderflowException {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public long addressForWrite(@NonNegative long offset) throws BufferOverflowException {
        Longs.requireNonNegative((long)offset);
        throw this.newUnsupportedOperationException();
    }

    @Override
    public long addressForWritePosition() throws UnsupportedOperationException, BufferOverflowException {
        throw this.newUnsupportedOperationException();
    }

    @Override
    @NotNull
    public Bytes<Void> bytesForWrite() {
        throw this.newUnsupportedOperationException();
    }

    @Override
    public boolean sharedMemory() {
        return false;
    }

    @Override
    @NotNull
    public EmptyByteStore zeroOut(long start, long end) throws IllegalStateException {
        if (start == 0L && end == 0L) {
            return this;
        }
        throw new BufferOverflowException();
    }

    @Override
    public boolean isImmutableEmptyByteStore() {
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        return "";
    }

    @Override
    @NotNull
    public IntStream chars() {
        return IntStream.empty();
    }

    @Override
    @NotNull
    public IntStream codePoints() {
        return IntStream.empty();
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public char charAt(int index) throws IndexOutOfBoundsException {
        throw this.newIndexOutOfBoundsException();
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        throw this.newIndexOutOfBoundsException();
    }

    public int hashCode() {
        return HASH_CODE_VALUE;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BytesStore)) {
            return false;
        }
        BytesStore other = (BytesStore)obj;
        return other.length() == 0;
    }

    private IndexOutOfBoundsException newIndexOutOfBoundsException() {
        return this.newException(IndexOutOfBoundsException::new);
    }

    private UnsupportedOperationException newUnsupportedOperationException() {
        return this.newException(UnsupportedOperationException::new);
    }

    private <X extends Exception> X newException(@NotNull Function<? super String, ? extends X> constructor) {
        return (X)((Exception)constructor.apply(OP_WITH_NO_CONTENT));
    }
}

