/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.DistributedUniqueTimeDeduplicator;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.ref.BinaryLongArrayReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.values.LongArrayValues;

public class DistributedUniqueTimeProvider
extends SimpleCloseable
implements TimeProvider {
    private static final int LAST_TIME = 128;
    private static final int DEDUPLICATOR = 192;
    static final int HOST_IDS = 100;
    private static final int NANOS_PER_MICRO = 1000;
    private final Bytes bytes;
    private final MappedFile file;
    private final BinaryLongArrayReference values;
    private final VanillaDistributedUniqueTimeDeduplicator deduplicator;
    private TimeProvider provider = SystemTimeProvider.INSTANCE;
    private int hostId;

    private DistributedUniqueTimeProvider(int hostId, boolean unmonitor) {
        this.hostId(hostId);
        try {
            this.file = MappedFile.ofSingle(new File(BytesUtil.TIME_STAMP_PATH), OS.pageSize(), false);
            if (unmonitor) {
                IOTools.unmonitor((Object)((Object)this.file));
            }
            this.bytes = this.file.acquireBytesForWrite((ReferenceOwner)this, 0L);
            if (unmonitor) {
                IOTools.unmonitor((Object)this.bytes);
            }
            this.bytes.append8bit("&TSF\nTime stamp file used for sharing a unique id\n");
            this.values = new BinaryLongArrayReference(100L);
            if (unmonitor) {
                IOTools.unmonitor((Object)this.values);
            }
            this.values.bytesStore((BytesStore)this.bytes, 192L, 816L);
            this.deduplicator = new VanillaDistributedUniqueTimeDeduplicator(this.values);
        }
        catch (Exception ioe) {
            throw new IORuntimeException((Throwable)ioe);
        }
    }

    public static DistributedUniqueTimeProvider instance() {
        return DistributedUniqueTimeProviderHolder.INSTANCE;
    }

    protected void performClose() {
        super.performClose();
        Closeable.closeQuietly((Object)this.values);
        this.bytes.release((ReferenceOwner)this);
        this.file.releaseLast();
    }

    public static DistributedUniqueTimeProvider forHostId(int hostId) {
        return new DistributedUniqueTimeProvider(hostId, false);
    }

    public DistributedUniqueTimeProvider hostId(int hostId) {
        if (hostId < 0) {
            throw new IllegalArgumentException("Invalid hostId: " + hostId);
        }
        this.hostId = hostId % 100;
        return this;
    }

    public DistributedUniqueTimeProvider provider(TimeProvider provider) {
        this.provider = provider;
        return this;
    }

    public long currentTimeMillis() {
        return this.provider.currentTimeMillis();
    }

    public long currentTimeMicros() throws IllegalStateException {
        long timeus = this.provider.currentTimeMicros() / 100L;
        long time0us;
        long time;
        long time0;
        while (!this.bytes.compareAndSwapLong(128L, time0, time = (time0us = (time0 = this.bytes.readVolatileLong(128L)) / 100000L) >= timeus ? (time0us + 1L) * 100000L : timeus * 100000L)) {
            Jvm.nanoPause();
        }
        return time / 1000L + (long)this.hostId;
    }

    public static long timestampFor(long timestampWithHostId) {
        return timestampWithHostId - timestampWithHostId % 100L;
    }

    public static long hostIdFor(long timestampWithHostId) {
        return timestampWithHostId % 100L;
    }

    public long currentTimeNanos() throws IllegalStateException {
        long time = this.provider.currentTimeNanos();
        long time0 = this.bytes.readVolatileLong(128L);
        long timeN = DistributedUniqueTimeProvider.timestampFor(time) + (long)this.hostId;
        if (timeN > time0 && this.bytes.compareAndSwapLong(128L, time0, timeN)) {
            return timeN;
        }
        return this.currentTimeNanosLoop();
    }

    private long currentTimeNanosLoop() {
        while (true) {
            long time0;
            long next;
            if ((next = DistributedUniqueTimeProvider.timestampFor(time0 = this.bytes.readVolatileLong(128L)) + (long)this.hostId) <= time0) {
                next += 100L;
            }
            if (this.bytes.compareAndSwapLong(128L, time0, next)) {
                return next;
            }
            Jvm.nanoPause();
        }
    }

    public DistributedUniqueTimeDeduplicator deduplicator() {
        return this.deduplicator;
    }

    static class VanillaDistributedUniqueTimeDeduplicator
    implements ReferenceOwner,
    DistributedUniqueTimeDeduplicator {
        private final LongArrayValues values;

        private VanillaDistributedUniqueTimeDeduplicator(LongArrayValues values) {
            this.values = values;
        }

        @Override
        public int compareByHostId(long timestampHostId) {
            int hostId = (int)DistributedUniqueTimeProvider.hostIdFor(timestampHostId);
            long prev = this.values.getValueAt((long)hostId);
            return Long.compare(timestampHostId, prev);
        }

        @Override
        public int compareAndRetainNewer(long timestampHostId) {
            long prev;
            int ret;
            int hostId = (int)DistributedUniqueTimeProvider.hostIdFor(timestampHostId);
            while ((ret = Long.compare(timestampHostId, prev = this.values.getValueAt((long)hostId))) > 0 && !this.values.compareAndSet((long)hostId, prev, timestampHostId)) {
            }
            return ret;
        }
    }

    static class DistributedUniqueTimeProviderHolder {
        private static final Integer DEFAULT_HOST_ID = Integer.getInteger("hostId", 0);
        public static final DistributedUniqueTimeProvider INSTANCE = new DistributedUniqueTimeProvider(DEFAULT_HOST_ID, true);

        DistributedUniqueTimeProviderHolder() {
        }
    }
}

