/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.HexDumpBytes;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.annotation.DontChain;
import net.openhft.chronicle.core.io.IORuntimeException;

@DontChain
public interface BytesMarshallable
extends ReadBytesMarshallable,
WriteBytesMarshallable {
    @Override
    default public boolean usesSelfDescribingMessage() {
        return false;
    }

    @Override
    default public void readMarshallable(BytesIn bytes) throws IORuntimeException, BufferUnderflowException, IllegalStateException {
        BytesUtil.readMarshallable(this, bytes);
    }

    @Override
    default public void writeMarshallable(BytesOut bytes) throws IllegalStateException, BufferOverflowException, BufferUnderflowException, ArithmeticException {
        BytesUtil.writeMarshallable(this, bytes);
    }

    default public String $toString() {
        try {
            HexDumpBytes bytes = new HexDumpBytes();
            this.writeMarshallable(bytes);
            String s = "# " + this.getClass().getName() + "\n" + bytes.toHexString();
            bytes.releaseLast();
            return s;
        }
        catch (Throwable e) {
            return e.toString();
        }
    }
}

