/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.util;

import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.algo.BytesStoreHash;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.pool.StringInterner;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public class StringInternerBytes
extends StringInterner {
    public StringInternerBytes(int capacity) throws IllegalArgumentException {
        super(capacity);
    }

    public String intern(@NotNull Bytes bytes) throws ArithmeticException, IllegalStateException, BufferUnderflowException {
        return this.intern(bytes, Maths.toUInt31((long)bytes.readRemaining()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String intern(@NotNull Bytes bytes, int length) throws IllegalStateException, BufferUnderflowException {
        try {
            int hash32 = BytesStoreHash.hash32(bytes, length);
            int h = hash32 & this.mask;
            String s = this.interner[h];
            long position = bytes.readPosition();
            if (BytesUtil.bytesEqual(s, bytes, position, length)) {
                String string = s;
                return string;
            }
            int h2 = hash32 >> this.shift & this.mask;
            String s2 = this.interner[h2];
            if (BytesUtil.bytesEqual(s2, bytes, position, length)) {
                String string = s2;
                return string;
            }
            char[] chars = BytesUtil.toCharArray(bytes, position, length);
            String string = StringUtils.newString((char[])chars);
            this.interner[s == null || s2 != null && this.toggle() ? h : h2] = string;
            String string2 = string;
            return string2;
        }
        finally {
            bytes.readSkip(length);
        }
    }
}

