/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesMarshaller;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.StreamingDataOutput;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum BytesUtil {


    public static String findFile(@NotNull String name) throws FileNotFoundException {
        File file = new File(name);
        URL url = null;
        if (!file.exists()) {
            url = IOTools.urlFor((String)name);
            String file2 = url.getFile().replace("target/test-classes", "src/test/resources");
            file = new File(file2);
        }
        if (!file.exists()) {
            throw new FileNotFoundException(name);
        }
        return file.getAbsolutePath();
    }

    public static Bytes readFile(@NotNull String name) throws IOException {
        if (name.startsWith("=")) {
            return Bytes.from(name.substring(1));
        }
        File file = new File(name);
        URL url = null;
        if (!file.exists()) {
            url = IOTools.urlFor((String)name);
            file = new File(url.getFile());
        }
        return Bytes.wrapForRead(IOTools.readAsBytes((InputStream)(url == null ? new FileInputStream(file) : IOTools.open((URL)url))));
    }

    public static void writeFile(String file, Bytes<byte[]> bytes) throws IOException {
        try (FileOutputStream os = new FileOutputStream(file);){
            ((OutputStream)os).write((byte[])bytes.underlyingObject());
        }
    }

    public static boolean bytesEqual(@NotNull RandomDataInput a, long offset, @NotNull RandomDataInput second, long secondOffset, long len) throws BufferUnderflowException {
        long i = 0L;
        while (len - i >= 8L) {
            if (a.readLong(offset + i) != second.readLong(secondOffset + i)) {
                return false;
            }
            i += 8L;
        }
        if (len - i >= 4L) {
            if (a.readInt(offset + i) != second.readInt(secondOffset + i)) {
                return false;
            }
            i += 4L;
        }
        if (len - i >= 2L) {
            if (a.readShort(offset + i) != second.readShort(secondOffset + i)) {
                return false;
            }
            i += 2L;
        }
        if (i < len) {
            return a.readByte(offset + i) == second.readByte(secondOffset + i);
        }
        return true;
    }

    public static boolean bytesEqual(@Nullable CharSequence cs, @NotNull RandomDataInput bs, long offset, int length) {
        if (cs == null || cs.length() != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (cs.charAt(i) == bs.readUnsignedByte(offset + (long)i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 instanceof CharSequence && o2 instanceof CharSequence) {
            return StringUtils.isEqual((CharSequence)((CharSequence)o1), (CharSequence)((CharSequence)o2));
        }
        return o1 != null && o1.equals(o2);
    }

    public static int asInt(@NotNull String str) {
        @NotNull ByteBuffer bb = ByteBuffer.wrap(str.getBytes(StandardCharsets.ISO_8859_1)).order(ByteOrder.nativeOrder());
        return bb.getInt();
    }

    public static int stopBitLength(long n) {
        if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((n & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        return BytesInternal.stopBitLength0(n);
    }

    @NotNull
    public static char[] toCharArray(@NotNull Bytes bytes) {
        @NotNull char[] chars = new char[Maths.toUInt31((long)bytes.readRemaining())];
        int i = 0;
        while ((long)i < bytes.readRemaining()) {
            chars[i] = (char)bytes.readUnsignedByte((long)i + bytes.readPosition());
            ++i;
        }
        return chars;
    }

    @NotNull
    public static char[] toCharArray(@NotNull Bytes bytes, long position, int length) {
        @NotNull char[] chars = new char[length];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            chars[j++] = (char)bytes.readUnsignedByte(position + (long)i);
        }
        return chars;
    }

    public static long readStopBit(@NotNull StreamingDataInput in) throws IORuntimeException {
        return BytesInternal.readStopBit(in);
    }

    public static void writeStopBit(@NotNull StreamingDataOutput out, long n) {
        BytesInternal.writeStopBit(out, n);
    }

    public static void parseUtf8(@NotNull StreamingDataInput in, Appendable appendable, int utflen) throws UTFDataFormatRuntimeException {
        BytesInternal.parseUtf8(in, appendable, true, utflen);
    }

    public static void appendUtf8(@NotNull StreamingDataOutput out, @NotNull CharSequence cs) {
        BytesInternal.appendUtf8(out, cs, 0, cs.length());
    }

    public static void appendBytesFromStart(@NotNull Bytes bytes, long startPosition, @NotNull StringBuilder sb) {
        try {
            BytesInternal.parse8bit(startPosition, bytes, sb, (int)(bytes.readPosition() - startPosition));
            sb.append('\u2016');
            sb.append(bytes);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static void readMarshallable(@NotNull ReadBytesMarshallable marshallable, BytesIn bytes) {
        ((BytesMarshaller)BytesMarshaller.BYTES_MARSHALLER_CL.get(marshallable.getClass())).readMarshallable(marshallable, bytes);
    }

    public static void writeMarshallable(@NotNull WriteBytesMarshallable marshallable, BytesOut bytes) {
        ((BytesMarshaller)BytesMarshaller.BYTES_MARSHALLER_CL.get(marshallable.getClass())).writeMarshallable(marshallable, bytes);
    }

    @Deprecated
    public static long utf8Length(@NotNull CharSequence toWrite) {
        return AppendableUtil.findUtf8Length(toWrite);
    }

    static String asString(String s, Throwable t) {
        StringWriter sw = new StringWriter();
        sw.append(s).append("\n");
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static void checkRegisteredBytes() {
        AbstractReferenceCounted.assertReferencesReleased();
    }

    public static boolean byteToBoolean(byte b) {
        return b != 0 && b != 78 && b != 110;
    }

    public static long roundUpTo64ByteAlign(long x) {
        return x + 63L & 0xFFFFFFFFFFFFFFC0L;
    }

    public static long roundUpTo8ByteAlign(long x) {
        return x + 7L & 0xFFFFFFFFFFFFFFF8L;
    }

    public static void read8ByteAlignPadding(Bytes<?> bytes) {
        bytes.readPosition(BytesUtil.roundUpTo8ByteAlign(bytes.readPosition()));
    }

    public static void write8ByteAlignPadding(Bytes<?> bytes) {
        long start = bytes.writePosition();
        long end = BytesUtil.roundUpTo8ByteAlign(start);
        bytes.writePosition(end);
        bytes.zeroOut(start, end);
    }

    public static String toDebugString(@NotNull RandomDataInput bytes, long start, long maxLength) {
        BytesStore bytes2 = bytes.subBytes(start, maxLength);
        return bytes2.toDebugString(maxLength);
    }

    @Deprecated
    public static boolean unregister(BytesStore bs) {
        AbstractReferenceCounted.unmonitor((ReferenceCounted)bs);
        return true;
    }

    static class WarnUncheckedElasticBytes {
        WarnUncheckedElasticBytes() {
        }

        static void warn() {
        }

        static {
            Jvm.debug().on(WarnUncheckedElasticBytes.class, "Wrapping elastic bytes with unchecked() will require calling ensureCapacity() as needed!");
        }
    }
}

