/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesInternal;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.StopCharsTester;
import net.openhft.chronicle.bytes.StreamingDataInput;
import net.openhft.chronicle.bytes.UTFDataFormatRuntimeException;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.ForceInline;
import org.jetbrains.annotations.NotNull;

public enum AppendableUtil {


    public static void setCharAt(@NotNull Appendable sb, int index, char ch) throws IllegalArgumentException, BufferOverflowException {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).setCharAt(index, ch);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).writeByte(index, ch);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static void parseUtf8(@NotNull BytesStore bs, StringBuilder sb, int utflen) throws UTFDataFormatRuntimeException {
        BytesInternal.parseUtf8(bs, bs.readPosition(), sb, utflen);
    }

    @ForceInline
    public static void setLength(@NotNull Appendable sb, int newLength) throws BufferUnderflowException, IllegalArgumentException {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).setLength(newLength);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).readPositionRemaining(0L, newLength);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static void append(@NotNull Appendable sb, double value) throws IllegalArgumentException, BufferOverflowException {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).append(value);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).append(value);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static void append(@NotNull Appendable sb, long value) throws IllegalArgumentException, BufferOverflowException {
        if (sb instanceof StringBuilder) {
            ((StringBuilder)sb).append(value);
        } else if (sb instanceof Bytes) {
            ((Bytes)sb).append(value);
        } else {
            throw new IllegalArgumentException("" + sb.getClass());
        }
    }

    public static <ACS extends Appendable & CharSequence> void append(@NotNull ACS sb, String str) {
        try {
            sb.append(str);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void read8bitAndAppend(@NotNull StreamingDataInput bytes, @NotNull StringBuilder appendable, @NotNull StopCharsTester tester) {
        do {
            int c;
            if (tester.isStopChar(c = bytes.readUnsignedByte(), bytes.peekUnsignedByte())) {
                return;
            }
            appendable.append((char)c);
        } while (bytes.readRemaining() != 0L);
    }

    public static void readUTFAndAppend(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, @NotNull StopCharsTester tester) throws BufferUnderflowException {
        try {
            AppendableUtil.readUtf8AndAppend(bytes, appendable, tester);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void readUtf8AndAppend(@NotNull StreamingDataInput bytes, @NotNull Appendable appendable, @NotNull StopCharsTester tester) throws BufferUnderflowException, IOException {
        int c;
        block15: {
            do {
                if ((c = bytes.readUnsignedByte()) >= 128) {
                    bytes.readSkip(-1L);
                    break block15;
                }
                if (tester.isStopChar(c, bytes.peekUnsignedByte())) {
                    return;
                }
                appendable.append((char)c);
            } while (bytes.readRemaining() != 0L);
            return;
        }
        block6: while ((c = bytes.readUnsignedByte()) >= 0) {
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (tester.isStopChar(c, bytes.peekUnsignedByte())) {
                        return;
                    }
                    appendable.append((char)c);
                    continue block6;
                }
                case 12: 
                case 13: {
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + Integer.toHexString(char2));
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if (tester.isStopChar(c2, bytes.peekUnsignedByte())) {
                        return;
                    }
                    appendable.append(c2);
                    continue block6;
                }
                case 14: {
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + Integer.toHexString(char2));
                    }
                    if ((char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + Integer.toHexString(char3));
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if (tester.isStopChar(c3, bytes.peekUnsignedByte())) {
                        return;
                    }
                    appendable.append(c3);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + Integer.toHexString(c));
        }
    }

    public static void parse8bit_SB1(@NotNull Bytes bytes, @NotNull StringBuilder sb, int utflen) throws BufferUnderflowException {
        if ((long)utflen > bytes.readRemaining()) {
            throw new BufferUnderflowException();
        }
        NativeBytesStore nbs = (NativeBytesStore)bytes.bytesStore();
        long offset = bytes.readPosition();
        int count = BytesInternal.parse8bit_SB1(offset, nbs, sb, utflen);
        bytes.readSkip(count);
    }

    public static void parse8bit(@NotNull StreamingDataInput bytes, Appendable appendable, int utflen) throws BufferUnderflowException, IOException {
        if (appendable instanceof StringBuilder) {
            StringBuilder sb = (StringBuilder)appendable;
            if (bytes instanceof Bytes && ((Bytes)bytes).bytesStore() instanceof NativeBytesStore) {
                AppendableUtil.parse8bit_SB1((Bytes)bytes, sb, utflen);
            } else {
                BytesInternal.parse8bit1(bytes, sb, utflen);
            }
        } else {
            BytesInternal.parse8bit1(bytes, appendable, utflen);
        }
    }

    public static <ACS extends Appendable & CharSequence> void append(ACS a, CharSequence cs, long start, long len) {
        if (a instanceof StringBuilder) {
            if (cs instanceof Bytes) {
                ((StringBuilder)a).append(Bytes.toString((Bytes)cs, start, len));
            } else {
                ((StringBuilder)a).append(cs.subSequence(Maths.toInt32((long)start), Maths.toInt32((long)len)));
            }
        } else if (a instanceof Bytes) {
            ((Bytes)a).appendUtf8(cs, Maths.toInt32((long)start), Maths.toInt32((long)len));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static long findUtf8Length(@NotNull CharSequence str) throws IndexOutOfBoundsException {
        int strlen = str.length();
        long utflen = strlen;
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f') continue;
            if (c <= '\u07ff') {
                ++utflen;
                continue;
            }
            utflen += 2L;
        }
        return utflen;
    }

    public static long findUtf8Length(@NotNull byte[] bytes, byte coder) {
        long utflen;
        if (coder == 0) {
            int strlen = bytes.length;
            utflen = bytes.length;
            for (int i = 0; i < strlen; ++i) {
                int b = bytes[i] & 0xFF;
                if (b <= 127) continue;
                ++utflen;
            }
        } else {
            int strlen = bytes.length;
            utflen = 0L;
            for (int i = 0; i < strlen; i += 2) {
                char c = (char)((bytes[i + 1] & 0xFF) << 8 | bytes[i] & 0xFF);
                if (c <= '\u007f') {
                    ++utflen;
                    continue;
                }
                if (c <= '\u07ff') {
                    utflen += 2L;
                    continue;
                }
                utflen += 3L;
            }
        }
        return utflen;
    }

    public static long findUtf8Length(@NotNull byte[] chars) {
        int c;
        long utflen = 0L;
        int strlen = chars.length;
        for (int i = 0; i < strlen && (c = chars[i] & 0xFF) != 0; ++i) {
            if (c >= 240) {
                utflen += 4L;
                i += 3;
                continue;
            }
            if (c >= 224) {
                utflen += 3L;
                i += 2;
                continue;
            }
            if (c >= 192) {
                utflen += 2L;
                ++i;
                continue;
            }
            ++utflen;
        }
        return utflen;
    }

    public static long findUtf8Length(@NotNull char[] chars) {
        long utflen = chars.length;
        for (char c : chars) {
            if (c <= '\u007f') continue;
            if (c <= '\u07ff') {
                ++utflen;
                continue;
            }
            utflen += 2L;
        }
        return utflen;
    }
}

