/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.NativeBytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.ReferenceCounted;
import org.jetbrains.annotations.NotNull;

public class ReadOnlyMappedBytesStore
extends MappedBytesStore {
    public ReadOnlyMappedBytesStore(ReferenceCounted owner, long start, long address, long capacity, long safeCapacity) throws IllegalStateException {
        super(owner, start, address, capacity, safeCapacity);
    }

    @Override
    @NotNull
    public NativeBytesStore<Void> zeroOut(long start, long end) throws IllegalArgumentException {
        this.checkReadOnly();
        return super.zeroOut(start, end);
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int value) {
        this.checkReadOnly();
        return super.compareAndSwapInt(offset, expected, value);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long value) {
        this.checkReadOnly();
        return super.compareAndSwapLong(offset, expected, value);
    }

    @Override
    @NotNull
    public NativeBytesStore<Void> writeByte(long offset, byte i8) {
        this.checkReadOnly();
        return super.writeByte(offset, i8);
    }

    @Override
    @NotNull
    public NativeBytesStore<Void> writeShort(long offset, short i16) {
        this.checkReadOnly();
        return super.writeShort(offset, i16);
    }

    @Override
    @NotNull
    public NativeBytesStore<Void> writeInt(long offset, int i32) {
        this.checkReadOnly();
        return super.writeInt(offset, i32);
    }

    @Override
    @NotNull
    public NativeBytesStore<Void> writeLong(long offset, long i64) {
        this.checkReadOnly();
        return super.writeLong(offset, i64);
    }

    @Override
    @NotNull
    public NativeBytesStore<Void> writeOrderedLong(long offset, long i) {
        this.checkReadOnly();
        return super.writeOrderedLong(offset, i);
    }

    @Override
    @NotNull
    public NativeBytesStore<Void> writeFloat(long offset, float f) {
        this.checkReadOnly();
        return super.writeFloat(offset, f);
    }

    @Override
    @NotNull
    public NativeBytesStore<Void> writeDouble(long offset, double d) {
        this.checkReadOnly();
        return super.writeDouble(offset, d);
    }

    @Override
    @NotNull
    public NativeBytesStore<Void> writeVolatileByte(long offset, byte i8) {
        this.checkReadOnly();
        return super.writeVolatileByte(offset, i8);
    }

    @Override
    @NotNull
    public NativeBytesStore<Void> writeVolatileShort(long offset, short i16) {
        this.checkReadOnly();
        return super.writeVolatileShort(offset, i16);
    }

    @Override
    @NotNull
    public NativeBytesStore<Void> writeVolatileInt(long offset, int i32) {
        this.checkReadOnly();
        return super.writeVolatileInt(offset, i32);
    }

    @Override
    @NotNull
    public NativeBytesStore<Void> writeVolatileLong(long offset, long i64) {
        this.checkReadOnly();
        return super.writeVolatileLong(offset, i64);
    }

    @Override
    @NotNull
    public NativeBytesStore<Void> write(long offsetInRDO, byte[] bytes, int offset, int length) {
        this.checkReadOnly();
        return super.write(offsetInRDO, bytes, offset, length);
    }

    @Override
    public void write(long offsetInRDO, @NotNull ByteBuffer bytes, int offset, int length) {
        this.checkReadOnly();
        super.write(offsetInRDO, bytes, offset, length);
    }

    @Override
    @NotNull
    public NativeBytesStore<Void> write(long offsetInRDO, @NotNull RandomDataInput bytes, long offset, long length) throws BufferOverflowException, BufferUnderflowException {
        this.checkReadOnly();
        return super.write(offsetInRDO, bytes, offset, length);
    }

    @Override
    public void write0(long offsetInRDO, @NotNull RandomDataInput bytes, long offset, long length) {
        this.checkReadOnly();
        super.write0(offsetInRDO, bytes, offset, length);
    }

    @Override
    public void nativeWrite(long address, long position, long size) {
        this.checkReadOnly();
        super.nativeWrite(address, position, size);
    }

    @Override
    void write8bit(long position, char[] chars, int offset, int length) {
        this.checkReadOnly();
        super.write8bit(position, chars, offset, length);
    }

    @Override
    public long appendUTF(long pos, char[] chars, int offset, int length) {
        this.checkReadOnly();
        return super.appendUTF(pos, chars, offset, length);
    }

    @Override
    public long appendUtf8(long pos, char[] chars, int offset, int length) {
        this.checkReadOnly();
        return super.appendUtf8(pos, chars, offset, length);
    }

    private void checkReadOnly() {
        throw new IllegalStateException("Read Only");
    }

    @Override
    @NotNull
    public VanillaBytes<Void> bytesForWrite() throws IllegalStateException {
        this.checkReadOnly();
        return super.bytesForWrite();
    }

    @Override
    @NotNull
    public NativeBytesStore<Void> writeOrderedInt(long offset, int i) {
        this.checkReadOnly();
        return super.writeOrderedInt(offset, i);
    }
}

